/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.awt.image.BufferedImage;
import java.lang.reflect.Method;
import junit.framework.Test;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper2;
import org.fest.swing.annotation.GUITestFinder;
import org.fest.swing.image.ImageException;
import org.fest.swing.image.ScreenshotTaker;
import org.fest.swing.junit.ant.ImageHandler;
import org.fest.swing.junit.ant.XmlJUnitResultFormatter;
import org.fest.util.Strings;
import org.w3c.dom.Element;

public final class ScreenshotOnFailureResultFormatter
extends XmlJUnitResultFormatter {
    private static final String SCREENSHOT_ELEMENT = "screenshot";
    private static final String SCREENSHOT_FILE_ATTRIBUTE = "file";
    private ScreenshotTaker screenshotTaker;
    private boolean ready;
    private ImageException couldNotCreateScreenshotTaker;

    public ScreenshotOnFailureResultFormatter() {
        try {
            this.screenshotTaker = new ScreenshotTaker();
            this.ready = true;
        }
        catch (ImageException e) {
            this.couldNotCreateScreenshotTaker = e;
        }
    }

    protected void onStartTestSuite(JUnitTest suite) {
        if (this.couldNotCreateScreenshotTaker == null) {
            return;
        }
        this.writeCouldNotCreateScreenshotTakerError();
        this.couldNotCreateScreenshotTaker = null;
    }

    private void writeCouldNotCreateScreenshotTakerError() {
        Element errorElement = this.document().createElement("error");
        this.writeErrorAndStackTrace(this.couldNotCreateScreenshotTaker, errorElement);
        this.rootElement().appendChild(errorElement);
    }

    protected void onFailureOrError(Test test, Throwable error, Element errorElement) {
        String methodName;
        if (!this.ready) {
            return;
        }
        String className = JUnitVersionHelper2.testClassName(test);
        if (!this.isGUITest(className, methodName = JUnitVersionHelper2.testMethodName(test))) {
            return;
        }
        String image = this.takeScreenshotAndReturnEncoded();
        if (Strings.isEmpty((String)image)) {
            return;
        }
        String imageFileName = Strings.join((String[])new String[]{className, methodName, "png"}).with(".");
        this.writeScreenshotFileName(image, imageFileName, errorElement);
    }

    private boolean isGUITest(String className, String methodName) {
        try {
            Class<?> testClass = Class.forName(className);
            Method testMethod = testClass.getDeclaredMethod(methodName, new Class[0]);
            return GUITestFinder.isGUITest(testClass, (Method)testMethod);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String takeScreenshotAndReturnEncoded() {
        BufferedImage image = this.screenshotTaker.takeDesktopScreenshot();
        return ImageHandler.encodeBase64(image);
    }

    private void writeScreenshotFileName(String encodedImage, String imageFileName, Element errorElement) {
        Element screenshotElement = this.document().createElement(SCREENSHOT_ELEMENT);
        screenshotElement.setAttribute(SCREENSHOT_FILE_ATTRIBUTE, imageFileName);
        this.writeText(encodedImage, screenshotElement);
        errorElement.getParentNode().appendChild(screenshotElement);
    }
}

