/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Formatting;
import org.fest.assertions.PrimitiveAssert;
import org.fest.assertions.PrimitiveFail;
import org.fest.util.Strings;

public final class CharAssert
extends PrimitiveAssert {
    private final char actual;

    CharAssert(char actual) {
        this.actual = actual;
    }

    public CharAssert as(String description) {
        return (CharAssert)this.description(description);
    }

    public CharAssert describedAs(String description) {
        return this.as(description);
    }

    public CharAssert isEqualTo(char expected) {
        PrimitiveFail.failIfNotEqual(this.description(), this.actual, expected);
        return this;
    }

    public CharAssert isNotEqualTo(char value) {
        PrimitiveFail.failIfEqual(this.description(), this.actual, value);
        return this;
    }

    public CharAssert isGreaterThan(char value) {
        PrimitiveFail.failIfNotGreaterThan(this.description(), this.actual, value);
        return this;
    }

    public CharAssert isLessThan(char value) {
        PrimitiveFail.failIfNotLessThan(this.description(), this.actual, value);
        return this;
    }

    public CharAssert isGreaterThanOrEqualTo(char value) {
        PrimitiveFail.failIfNotGreaterThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public CharAssert isLessThanOrEqualTo(char value) {
        PrimitiveFail.failIfNotLessThanOrEqualTo(this.description(), this.actual, value);
        return this;
    }

    public CharAssert isUpperCase() {
        if (!Character.isUpperCase(this.actual)) {
            this.fail(Strings.concat((Object[])new Object[]{Formatting.inBrackets(Character.valueOf(this.actual)), " should be an uppercase character"}));
        }
        return this;
    }

    public CharAssert isLowerCase() {
        if (!Character.isLowerCase(this.actual)) {
            this.fail(Strings.concat((Object[])new Object[]{Formatting.inBrackets(Character.valueOf(this.actual)), " should be a lowercase character"}));
        }
        return this;
    }
}

