/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import javax.swing.SwingUtilities;
import org.fest.swing.monitor.WindowMetrics;
import org.fest.swing.monitor.Windows;
import org.fest.swing.util.AWT;

class WindowStatus {
    private static final int ARBITRARY_EXTRA_VALUE = 20;
    private static int sign = 1;
    private final Windows windows;
    private final Robot robot;

    WindowStatus(Windows windows) {
        this(windows, WindowStatus.createRobot());
    }

    WindowStatus(Windows windows, Robot robot) {
        this.windows = windows;
        this.robot = robot;
    }

    private static Robot createRobot() {
        try {
            return new Robot();
        }
        catch (AWTException e) {
            return null;
        }
    }

    Windows windows() {
        return this.windows;
    }

    void checkIfReady(Window w) {
        if (this.robot == null) {
            return;
        }
        WindowMetrics metrics = new WindowMetrics(w);
        this.mouseMove(w, metrics.center());
        if (this.windows.isShowingButNotReady(w) && this.isEmptyFrame(w)) {
            this.makeLargeEnoughToReceiveEvents(w, metrics);
        }
    }

    private void mouseMove(Window w, Point point) {
        int x = point.x;
        int y = point.y;
        if (x == 0 || y == 0) {
            return;
        }
        this.robot.mouseMove(x, y);
        if (w.getWidth() > w.getHeight()) {
            this.robot.mouseMove(x + sign, y);
        } else {
            this.robot.mouseMove(x, y + sign);
        }
        sign = -sign;
    }

    private boolean isEmptyFrame(Window w) {
        Insets insets = AWT.insetsFrom(w);
        return insets.top + insets.bottom == w.getHeight() || insets.left + insets.right == w.getWidth();
    }

    private void makeLargeEnoughToReceiveEvents(Window window, WindowMetrics metrics) {
        int w = Math.max(window.getWidth(), this.proposedWidth(metrics));
        int h = Math.max(window.getHeight(), this.proposedHeight(metrics));
        SwingUtilities.invokeLater(new WindowSizeSetter(window, new Dimension(w, h)));
    }

    private int proposedWidth(WindowMetrics metrics) {
        return metrics.verticalInsets() + 20;
    }

    private int proposedHeight(WindowMetrics metrics) {
        return metrics.horizontalInsets() + 20;
    }

    static int sign() {
        return sign;
    }

    private static class WindowSizeSetter
    implements Runnable {
        private final Window window;
        private final Dimension size;

        WindowSizeSetter(Window window, Dimension size) {
            this.window = window;
            this.size = size;
        }

        public void run() {
            this.window.setSize(this.size);
        }
    }
}

