/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.fest.swing.hierarchy.ComponentHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleComponentHierarchy
implements ComponentHierarchy {
    private final Container root;
    private final ComponentHierarchy delegate;
    private final List<Container> roots = new ArrayList<Container>();

    public SingleComponentHierarchy(Container root, ComponentHierarchy delegate) {
        this.root = root;
        this.delegate = delegate;
        this.roots.add(root);
    }

    @Override
    public Collection<? extends Container> roots() {
        return this.roots;
    }

    @Override
    public Collection<Component> childrenOf(Component c) {
        return this.delegate.childrenOf(c);
    }

    @Override
    public Container parentOf(Component c) {
        return this.delegate.parentOf(c);
    }

    @Override
    public boolean contains(Component c) {
        return this.delegate.contains(c) && SwingUtilities.isDescendingFrom(c, this.root);
    }

    @Override
    public void dispose(Window w) {
        this.delegate.dispose(w);
    }
}

