/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ChildrenFinder;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ParentFinder;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.util.AWT;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExistingHierarchy
implements ComponentHierarchy {
    private static WindowMonitor windowMonitor = WindowMonitor.instance();
    final ParentFinder parentFinder = new ParentFinder();
    final ChildrenFinder childrenFinder = new ChildrenFinder();
    final Logger logger = Logger.getLogger(this.getClass().getName());

    public static ExistingHierarchy instance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public Collection<? extends Container> roots() {
        return windowMonitor.rootWindows();
    }

    @Override
    public Container parentOf(Component c) {
        return this.parentFinder.parentOf(c);
    }

    @Override
    public boolean contains(Component c) {
        return true;
    }

    @Override
    public Collection<Component> childrenOf(Component c) {
        return this.childrenFinder.childrenOf(c);
    }

    @Override
    public void dispose(Window w) {
        if (AWT.isAppletViewer(w)) {
            return;
        }
        for (Window owned : w.getOwnedWindows()) {
            this.dispose(owned);
        }
        if (AWT.isSharedInvisibleFrame(w)) {
            return;
        }
        try {
            AWT.runInEventThreadAndWait(this.disposerFor(w));
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, Strings.concat((Object[])new Object[]{"Failed to dispose window ", Formatting.format(w)}), e);
        }
    }

    private Runnable disposerFor(final Window w) {
        return new Runnable(){

            public void run() {
                try {
                    w.dispose();
                }
                catch (Throwable e) {
                    ExistingHierarchy.this.logger.log(Level.WARNING, Strings.concat((Object[])new Object[]{"Ignoring exception thrown when disposing the window ", Formatting.format(w)}), e);
                }
            }
        };
    }

    private static class SingletonHolder {
        static final ExistingHierarchy INSTANCE = new ExistingHierarchy();

        private SingletonHolder() {
        }
    }
}

