/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JScrollBar;

public final class JScrollBarLocation {
    private static final int BLOCK_OFFSET = 4;

    public Point thumbLocation(JScrollBar scrollBar, int position) {
        double fraction = (double)position / (double)(scrollBar.getMaximum() - scrollBar.getMinimum());
        int arrow = this.arrow(scrollBar);
        if (this.isHorizontal(scrollBar)) {
            return new Point(arrow + (int)(fraction * (double)(scrollBar.getWidth() - 2 * arrow)), arrow / 2);
        }
        return new Point(arrow / 2, arrow + (int)(fraction * (double)(scrollBar.getHeight() - 2 * arrow)));
    }

    public Point blockLocationToScrollUp(JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollUp(scrollBar);
        int offset = 4;
        return this.blockLocation(scrollBar, p, offset);
    }

    public Point blockLocationToScrollDown(JScrollBar scrollBar) {
        Point p = this.unitLocationToScrollDown(scrollBar);
        int offset = -4;
        return this.blockLocation(scrollBar, p, offset);
    }

    private Point blockLocation(JScrollBar scrollBar, Point unitLocation, int offset) {
        if (this.isHorizontal(scrollBar)) {
            unitLocation.x += offset;
        } else {
            unitLocation.y += offset;
        }
        return unitLocation;
    }

    public Point unitLocationToScrollUp(JScrollBar scrollBar) {
        int arrow = this.arrow(scrollBar);
        if (this.isHorizontal(scrollBar)) {
            return new Point(scrollBar.getWidth() - arrow / 2, arrow / 2);
        }
        return new Point(arrow / 2, scrollBar.getHeight() - arrow / 2);
    }

    public Point unitLocationToScrollDown(JScrollBar scrollBar) {
        int arrow = this.arrow(scrollBar);
        return new Point(arrow / 2, arrow / 2);
    }

    private int arrow(JScrollBar scrollBar) {
        return this.isHorizontal(scrollBar) ? scrollBar.getHeight() : scrollBar.getWidth();
    }

    private boolean isHorizontal(JScrollBar scrollBar) {
        return scrollBar.getOrientation() == 0;
    }
}

