/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import org.fest.swing.exception.ScreenLockException;
import org.fest.util.Strings;

public final class ScreenLock {
    private boolean locked;
    private Object owner;

    synchronized Object owner() {
        return this.owner;
    }

    public synchronized void acquire(Object newOwner) {
        while (this.locked) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                break;
            }
            this.acquire(newOwner);
            this.notifyAll();
        }
        this.locked = true;
        this.owner = newOwner;
    }

    public synchronized boolean acquiredBy(Object possibleOwner) {
        if (!this.locked) {
            return false;
        }
        return this.owner == possibleOwner;
    }

    public synchronized void release(Object currentOwner) {
        if (!this.locked) {
            throw new ScreenLockException("No lock to release");
        }
        if (this.owner != currentOwner) {
            throw new ScreenLockException(Strings.concat((Object[])new Object[]{currentOwner, " is not the lock owner"}));
        }
        this.locked = false;
        this.owner = null;
    }

    public static ScreenLock instance() {
        return ScreenLockHolder.instance;
    }

    ScreenLock() {
    }

    private static class ScreenLockHolder {
        static ScreenLock instance = new ScreenLock();

        private ScreenLockHolder() {
        }
    }
}

