/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.core.ComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NameAndTypeMatcher
implements ComponentMatcher {
    private final String name;
    private final boolean requireShowing;
    private final Class<? extends Component> type;

    public NameAndTypeMatcher(String name, Class<? extends Component> type) {
        this(name, type, false);
    }

    public NameAndTypeMatcher(String name, Class<? extends Component> type, boolean requireShowing) {
        if (name == null) {
            throw new NullPointerException("The name of the component to find should not be null");
        }
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name of the component to find should not be empty");
        }
        if (type == null) {
            throw new NullPointerException("The type of component to find should not be null");
        }
        this.name = name;
        this.type = type;
        this.requireShowing = requireShowing;
    }

    @Override
    public boolean matches(Component c) {
        return Objects.areEqual((Object)this.name, (Object)c.getName()) && this.type.isAssignableFrom(c.getClass()) && (!this.requireShowing || c.isShowing());
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "name=", Strings.quote((String)this.name), ", ", "type=", this.type.getName(), ", ", "requireShowing=", String.valueOf(this.requireShowing), "]"});
    }
}

