/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.fest.swing.core.AWTEventPoster;
import org.fest.swing.core.FocusOwnerFinder;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.input.InputState;
import org.fest.swing.keystroke.KeyStrokeMap;
import org.fest.swing.util.AWT;
import org.fest.swing.util.Modifiers;
import org.fest.swing.util.MouseEventTarget;

class AWTEventGenerator
implements InputEventGenerator {
    private static final int MULTI_CLICK_INTERVAL = 250;
    private final InputState inputState;
    private final AWTEventPoster eventPoster;

    AWTEventGenerator(AWTEventPoster eventPoster) {
        this.inputState = eventPoster.inputState();
        this.eventPoster = eventPoster;
    }

    public void moveMouse(Component c, int x, int y) {
        Component target = c;
        Component eventSource = c;
        Point p = new Point(x, y);
        int eventId = 503;
        boolean outside = false;
        if (this.inputState.dragInProgress()) {
            eventId = 506;
            eventSource = this.inputState.dragSource();
        } else {
            MouseEventTarget newTarget = AWT.retargetMouseEvent(eventSource, eventId, p);
            eventSource = target = newTarget.source;
            p.setLocation(newTarget.position);
            outside = this.isPointOutsideComponent(p, target);
        }
        Component current = this.inputState.mouseComponent();
        if (current != target) {
            if (outside && current != null) {
                this.postMouseMotion(current, 505, SwingUtilities.convertPoint(target, p.x, p.y, current));
                return;
            }
            this.postMouseMotion(target, 504, new Point(p.x, p.y));
        }
        Point dragPosition = new Point(p.x, p.y);
        if (eventId == 506) {
            dragPosition = SwingUtilities.convertPoint(target, dragPosition, eventSource);
        }
        this.postMouseMotion(eventSource, eventId, dragPosition);
        if (outside) {
            this.postMouseMotion(target, 505, p);
        }
    }

    private boolean isPointOutsideComponent(Point p, Component c) {
        int x = p.x;
        int y = p.y;
        return x < 0 || y < 0 || x >= c.getWidth() || y >= c.getHeight();
    }

    public void releaseMouse(int buttons) {
        Component c = null;
        MouseEvent lastMousePress = this.eventPoster.lastMousePress();
        c = this.inputState.dragInProgress() ? this.inputState.dragSource() : (lastMousePress != null ? lastMousePress.getComponent() : this.inputState.mouseComponent());
        Point where = this.inputState.mouseLocation();
        if (c == null) {
            return;
        }
        if (where == null) {
            if (lastMousePress == null) {
                return;
            }
            where = lastMousePress.getPoint();
        }
        this.postMouseRelease(c, where.x, where.y, buttons);
    }

    private void postMouseRelease(Component c, int x, int y, int mask) {
        int count = this.inputState.clickCount();
        MouseEventTarget newTarget = AWT.retargetMouseEvent(c, 501, new Point(x, y));
        Component target = newTarget.source;
        Point where = newTarget.position;
        long when = System.currentTimeMillis();
        int modifiers = this.inputState.keyModifiers() | mask;
        boolean popupTrigger = !AWT.popupOnPress() && (mask & AWT.popupMask()) != 0;
        MouseEvent mouseEvent = new MouseEvent(target, 502, when, modifiers, where.x, where.y, count, popupTrigger);
        this.eventPoster.postEvent(c, mouseEvent);
    }

    private void postMouseMotion(Component c, int eventId, Point where) {
        Component target = c;
        Point position = where;
        if (eventId != 506) {
            MouseEventTarget newTarget = AWT.retargetMouseEvent(target, eventId, where);
            target = newTarget.source;
            position = newTarget.position;
        }
        long when = System.currentTimeMillis();
        int modifiers = this.inputState.modifiers();
        int x = position.x;
        int y = position.y;
        int clickCount = this.inputState.clickCount();
        this.eventPoster.postEvent(target, new MouseEvent(target, eventId, when, modifiers, x, y, clickCount, false));
    }

    public void pressMouse(int buttons) {
        Component c = this.inputState.mouseComponent();
        if (c == null) {
            return;
        }
        Point where = this.inputState.mouseLocation();
        this.pressMouse(c, where, buttons);
    }

    public void pressMouse(Component c, Point where, int buttons) {
        long current = System.currentTimeMillis();
        MouseEvent lastMousePress = this.eventPoster.lastMousePress();
        long last = lastMousePress != null ? lastMousePress.getWhen() : 0L;
        int count = 1;
        MouseEventTarget target = AWT.retargetMouseEvent(c, 501, where);
        Component source = target.source;
        if (this.eventPoster.countingClicks() && lastMousePress != null && source == lastMousePress.getComponent() && current - last < 250L) {
            count = this.inputState.clickCount() + 1;
        }
        int modifiers = this.inputState.keyModifiers() | buttons;
        int x = target.position.x;
        int y = target.position.y;
        boolean popupTrigger = AWT.popupOnPress() && (buttons & AWT.popupMask()) != 0;
        this.eventPoster.postEvent(source, new MouseEvent(source, 501, current, modifiers, x, y, count, popupTrigger));
    }

    public void pressKey(int keyCode, char keyChar) {
        char keyCharCopy = keyChar;
        int modifiers = this.inputState.modifiers();
        if (Modifiers.isModifier(keyCode)) {
            modifiers |= Modifiers.maskFor(keyCode);
        }
        this.postKeyEvent(401, modifiers, keyCode, '\uffff');
        int mask = this.inputState.modifiers();
        if (keyCharCopy == '\uffff') {
            keyCharCopy = KeyStrokeMap.charFor(KeyStroke.getKeyStroke(keyCode, mask));
        }
        if (keyCharCopy != '\uffff') {
            this.postKeyEvent(400, mask, 0, keyCharCopy);
        }
    }

    public void releaseKey(int keyCode) {
        int mods = this.inputState.modifiers();
        if (Modifiers.isModifier(keyCode)) {
            mods &= ~Modifiers.maskFor(keyCode);
        }
        this.postKeyEvent(402, mods, keyCode, '\uffff');
    }

    private void postKeyEvent(int eventId, int modifiers, int keyCode, char character) {
        Component c = FocusOwnerFinder.focusOwner();
        if (c == null) {
            return;
        }
        this.eventPoster.postEvent(c, new KeyEvent(c, eventId, System.currentTimeMillis(), modifiers, keyCode, character));
    }

    InputState inputState() {
        return this.inputState;
    }

    AWTEventPoster eventPoster() {
        return this.eventPoster;
    }
}

