/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import java.lang.reflect.Method;
import org.fest.reflect.exception.ReflectionError;
import org.fest.reflect.util.Accessibles;
import org.fest.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Invoker<T> {
    private final Object target;
    private final Method method;

    Invoker(String methodName, Class<?> target, Class<?> ... parameterTypes) {
        this.target = target;
        this.method = this.lookupInClassHierarchy(methodName, target, parameterTypes);
    }

    Invoker(String methodName, Object target, Class<?> ... parameterTypes) {
        this.target = target;
        this.method = this.lookupInClassHierarchy(methodName, target.getClass(), parameterTypes);
    }

    private Method lookupInClassHierarchy(String methodName, Class<?> targetType, Class<?>[] parameterTypes) {
        Method method = null;
        for (Class<?> type = targetType; type != null && (method = Invoker.method(methodName, type, parameterTypes)) == null; type = type.getSuperclass()) {
        }
        if (method == null) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to find method ", Strings.quote((String)methodName), " in ", targetType.getName(), " with parameter type(s) ", Arrays.format(parameterTypes)}));
        }
        return method;
    }

    private static Method method(String methodName, Class<?> type, Class<?>[] parameterTypes) {
        try {
            return type.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public T invoke(Object ... args) {
        boolean accessible = this.method.isAccessible();
        try {
            Accessibles.makeAccessible(this.method);
            Object object = this.method.invoke(this.target, args);
            return (T)object;
        }
        catch (Exception e) {
            throw new ReflectionError(Strings.concat((Object[])new Object[]{"Unable to invoke method ", Strings.quote((String)this.method.getName()), " with arguments ", Arrays.format((Object)args)}), e);
        }
        finally {
            Accessibles.setAccessibleIgnoringExceptions(this.method, accessible);
        }
    }

    public Method info() {
        return this.method;
    }
}

