/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.junit.ant;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitResultFormatter;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitVersionHelper2;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.fest.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class XmlJUnitResultFormatter
implements JUnitResultFormatter {
    private static final String UNKNOWN = "unknown";
    private Document document;
    private Element rootElement;
    private ConcurrentMap<Test, Element> testElements = new ConcurrentHashMap<Test, Element>();
    private ConcurrentMap<Test, Test> failedTests = new ConcurrentHashMap<Test, Test>();
    private ConcurrentMap<Test, Long> testStarts = new ConcurrentHashMap<Test, Long>();
    private OutputStream out;

    private static DocumentBuilder documentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exc) {
            throw new ExceptionInInitializerError(exc);
        }
    }

    public final void setOutput(OutputStream out) {
        this.out = out;
    }

    public final void setSystemOutput(String out) {
        this.formatOutput("system-out", out);
    }

    public final void setSystemError(String out) {
        this.formatOutput("system-err", out);
    }

    private void formatOutput(String type, String output) {
        Element nested = this.document.createElement(type);
        this.rootElement.appendChild(nested);
        nested.appendChild(this.document.createCDATASection(output));
    }

    protected final Document document() {
        return this.document;
    }

    protected final Element rootElement() {
        return this.rootElement;
    }

    public final void startTestSuite(JUnitTest suite) {
        this.document = XmlJUnitResultFormatter.documentBuilder().newDocument();
        this.rootElement = this.document.createElement("testsuite");
        this.writeSuiteName(suite.getName());
        this.writeTimestamp();
        this.writeHostname();
        this.writeProperties(suite);
        this.onStartTestSuite(suite);
    }

    private void writeSuiteName(String suiteName) {
        this.rootElement.setAttribute("name", suiteName == null ? UNKNOWN : suiteName);
    }

    private void writeHostname() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        this.rootElement.setAttribute("hostname", hostName);
    }

    private void writeTimestamp() {
        String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
        this.rootElement.setAttribute("timestamp", timestamp);
    }

    private void writeProperties(JUnitTest suite) {
        Element propertiesElement = this.document.createElement("properties");
        this.rootElement.appendChild(propertiesElement);
        Properties properties = suite.getProperties();
        if (properties == null) {
            return;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            Element propertyElement = this.document.createElement("property");
            propertyElement.setAttribute("name", name);
            propertyElement.setAttribute("value", properties.getProperty(name));
            propertiesElement.appendChild(propertyElement);
        }
    }

    protected void onStartTestSuite(JUnitTest suite) {
    }

    public final void endTestSuite(JUnitTest suite) throws BuildException {
        this.rootElement.setAttribute("tests", "" + suite.runCount());
        this.rootElement.setAttribute("failures", "" + suite.failureCount());
        this.rootElement.setAttribute("errors", "" + suite.errorCount());
        this.rootElement.setAttribute("time", "" + (double)suite.getRunTime() / 1000.0);
        if (this.out == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(this.out, "UTF8"));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
            new DOMElementWriter().write(this.rootElement, (Writer)writer, 0, "  ");
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new BuildException("Unable to write log file", (Throwable)e);
        }
        finally {
            if (this.out != System.out && this.out != System.err) {
                FileUtils.close((Writer)writer);
            }
        }
    }

    public final void startTest(Test test) {
        this.testStarts.put(test, System.currentTimeMillis());
    }

    public final void endTest(Test test) {
        if (!this.testStarts.containsKey(test)) {
            this.startTest(test);
        }
        Element currentTest = null;
        currentTest = !this.failedTests.containsKey(test) ? this.createAndAddCurrentTest(test) : (Element)this.testElements.get(test);
        this.writeExecutionTime(test, currentTest);
    }

    private Element createAndAddCurrentTest(Test test) {
        Element currentTest = this.document.createElement("testcase");
        String methodName = JUnitVersionHelper2.testMethodName(test);
        currentTest.setAttribute("name", methodName == null ? UNKNOWN : methodName);
        currentTest.setAttribute("classname", JUnitVersionHelper2.testClassName(test));
        this.rootElement.appendChild(currentTest);
        this.testElements.put(test, currentTest);
        return currentTest;
    }

    private void writeExecutionTime(Test test, Element currentTest) {
        long startTime = (Long)this.testStarts.get(test);
        double executionTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        currentTest.setAttribute("time", String.valueOf(executionTime));
    }

    public final void addFailure(Test test, Throwable error) {
        Element errorElement = this.formatError("failure", test, error);
        this.onFailureOrError(test, error, errorElement);
    }

    public final void addFailure(Test test, AssertionFailedError failedAssertion) {
        this.addFailure(test, (Throwable)failedAssertion);
    }

    public final void addError(Test test, Throwable error) {
        Element errorElement = this.formatError("error", test, error);
        this.onFailureOrError(test, error, errorElement);
    }

    private Element formatError(String type, Test test, Throwable error) {
        if (test != null) {
            this.endTest(test);
            this.failedTests.put(test, test);
        }
        Element errorElement = this.document.createElement(type);
        Element currentTest = null;
        currentTest = test != null ? (Element)this.testElements.get(test) : this.rootElement;
        currentTest.appendChild(errorElement);
        this.writeErrorAndStackTrace(error, errorElement);
        return errorElement;
    }

    protected final void writeErrorAndStackTrace(Throwable error, Element errorElement) {
        this.writeError(error, errorElement);
        this.writeStackTrace(error, errorElement);
    }

    private void writeError(Throwable error, Element destination) {
        String message = error.getMessage();
        if (!Strings.isEmpty((String)message)) {
            destination.setAttribute("message", error.getMessage());
        }
        destination.setAttribute("type", error.getClass().getName());
    }

    private final void writeStackTrace(Throwable error, Element destination) {
        String stackTrace = JUnitTestRunner.getFilteredTrace((Throwable)error);
        this.writeText(stackTrace, destination);
    }

    protected final void writeText(String text, Element destination) {
        Text textNode = this.document.createTextNode(text);
        destination.appendChild(textNode);
    }

    protected void onFailureOrError(Test test, Throwable error, Element errorElement) {
    }
}

