/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.lang.reflect.Array;
import org.fest.assertions.Fail;
import org.fest.swing.util.System;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Arrays {
    private static final String NO_COLUMNS = "[[]]";
    private static final String NO_ROWS = "[]";
    private static final String NULL = "null";

    public static void assertEquals(String[][] actual, String[][] expected, String message) {
        if (actual == null && expected == null) {
            return;
        }
        if (actual == null || expected == null) {
            Arrays.failNotEqual(actual, expected, message);
            return;
        }
        if (actual.length != expected.length) {
            Arrays.failNotEqual(actual, expected, message);
        }
        if (actual.length == 0) {
            return;
        }
        if (actual[0].length != expected[0].length) {
            Arrays.failNotEqual(actual, expected, message);
        }
        for (int i = 0; i < actual.length; ++i) {
            for (int j = 0; j < actual[i].length; ++j) {
                if (Objects.areEqual((Object)actual[i][j], (Object)expected[i][j])) continue;
                Arrays.failNotEqual(actual, expected, message);
            }
        }
    }

    private static void failNotEqual(String[][] actual, String[][] expected, String description) {
        String message = description == null ? "" : Strings.concat((Object[])new Object[]{"[", description, "]"});
        Fail.fail((String)Strings.concat((Object[])new Object[]{message, " expected:<", Arrays.format(expected), "> but was:<", Arrays.format(actual), ">"}));
    }

    public static String format(String[][] array) {
        if (array == null) {
            return NULL;
        }
        int size = array.length;
        if (size == 0) {
            return NO_ROWS;
        }
        if (array[0].length == 0) {
            return NO_COLUMNS;
        }
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                b.append(System.LINE_SEPARATOR).append(" ");
            }
            Arrays.addLine(array[i], b);
            if (i == size - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    private static void addLine(String[] line, StringBuilder b) {
        int lineSize = line.length;
        b.append("[");
        for (int i = 0; i < lineSize; ++i) {
            b.append(Strings.quote((String)line[i]));
            if (i == lineSize - 1) continue;
            b.append(", ");
        }
        b.append("]");
    }

    public static int[] copyOf(int[] array) {
        if (array == null) {
            throw new NullPointerException("The array to copy should not be null");
        }
        int arraySize = array.length;
        int[] copy = new int[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    public static <T> T[] copyOf(T[] array) {
        if (array == null) {
            throw new NullPointerException("The array to copy should not be null");
        }
        int arraySize = array.length;
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), arraySize);
        for (int i = 0; i < arraySize; ++i) {
            copy[i] = array[i];
        }
        return copy;
    }

    private Arrays() {
    }
}

