/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import org.fest.swing.monitor.Context;
import org.fest.swing.monitor.ContextMonitor;
import org.fest.swing.monitor.WindowAvailabilityMonitor;
import org.fest.swing.monitor.WindowStatus;
import org.fest.swing.monitor.Windows;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowMonitor {
    private final Context context;
    private final ContextMonitor contextMonitor;
    private final Windows windows;
    private final WindowStatus windowStatus;
    private final WindowAvailabilityMonitor windowAvailabilityMonitor;

    WindowMonitor(Toolkit toolkit) {
        this(toolkit, new Context(toolkit), new WindowStatus(new Windows()));
    }

    WindowMonitor(Toolkit toolkit, Context context, WindowStatus windowStatus) {
        this.context = context;
        this.windowStatus = windowStatus;
        this.windows = windowStatus.windows();
        this.contextMonitor = new ContextMonitor(context, this.windows);
        this.contextMonitor.attachTo(toolkit);
        this.windowAvailabilityMonitor = new WindowAvailabilityMonitor(this.windows);
        this.windowAvailabilityMonitor.attachTo(toolkit);
        this.populateExistingWindows();
    }

    private void populateExistingWindows() {
        for (Frame f : Frame.getFrames()) {
            this.examine(f);
        }
    }

    private void examine(Window w) {
        this.windows.attachNewWindowVisibilityMonitor(w);
        for (Window owned : w.getOwnedWindows()) {
            this.examine(owned);
        }
        this.windows.markExisting(w);
        this.context.addContextFor(w);
    }

    public boolean isWindowReady(Window w) {
        if (this.windows.isReady(w)) {
            return true;
        }
        this.windowStatus.checkIfReady(w);
        return false;
    }

    public EventQueue eventQueueFor(Component c) {
        return this.context.eventQueueFor(c);
    }

    public Collection<EventQueue> allEventQueues() {
        return this.context.allEventQueues();
    }

    public Collection<Window> rootWindows() {
        return this.context.rootWindows();
    }

    public static WindowMonitor instance() {
        return SingletonLazyLoader.INSTANCE;
    }

    private static class SingletonLazyLoader {
        static final WindowMonitor INSTANCE = new WindowMonitor(Toolkit.getDefaultToolkit());

        private SingletonLazyLoader() {
        }
    }
}

