/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.listener;

import java.awt.AWTEvent;
import java.awt.event.AWTEventListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class EventDispatchThreadedEventListener
implements AWTEventListener {
    private final List<AWTEvent> deferredEvents = new ArrayList<AWTEvent>();
    private final Object lock = new Object();
    private final Runnable processDeferredEventsTask = new Runnable(){

        public void run() {
            EventDispatchThreadedEventListener.this.processDeferredEvents();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventDispatched(AWTEvent event) {
        if (!SwingUtilities.isEventDispatchThread()) {
            Object object = this.lock;
            synchronized (object) {
                this.deferredEvents.add(event);
            }
            SwingUtilities.invokeLater(this.processDeferredEventsTask);
            return;
        }
        this.processDeferredEvents();
        this.processEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDeferredEvents() {
        ArrayList<AWTEvent> queue = new ArrayList<AWTEvent>();
        Object object = this.lock;
        synchronized (object) {
            queue.addAll(this.deferredEvents);
            this.deferredEvents.clear();
        }
        while (queue.size() > 0) {
            AWTEvent event = (AWTEvent)queue.get(0);
            queue.remove(0);
            this.processEvent(event);
        }
    }

    protected abstract void processEvent(AWTEvent var1);
}

