/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JOptionPaneDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.JScrollBarFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScrollPaneFixture
extends JPopupMenuInvokerFixture<JScrollPane>
implements CommonComponentFixture {
    private JComponentDriver driver;

    public JScrollPaneFixture(Robot robot, JScrollPane target) {
        super(robot, target);
        this.updateDriver(this.newComponentDriver());
    }

    final void updateDriver(JComponentDriver newDriver) {
        this.driver = newDriver;
    }

    public JScrollPaneFixture(Robot robot, String panelName) {
        super(robot, panelName, JScrollPane.class);
        this.driver = this.newComponentDriver();
    }

    private JComponentDriver newComponentDriver() {
        return new JOptionPaneDriver(this.robot);
    }

    public JScrollBarFixture horizontalScrollBar() {
        return this.scrollBarFixture(((JScrollPane)this.target).getHorizontalScrollBar());
    }

    public JScrollBarFixture verticalScrollBar() {
        return this.scrollBarFixture(((JScrollPane)this.target).getVerticalScrollBar());
    }

    private JScrollBarFixture scrollBarFixture(JScrollBar scrollBar) {
        return new JScrollBarFixture(this.robot, scrollBar);
    }

    @Override
    public JScrollPaneFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JScrollPaneFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JScrollPaneFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JScrollPaneFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JScrollPaneFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JScrollPaneFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JScrollPaneFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JScrollPaneFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JScrollPaneFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }
}

