/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.io.File;
import javax.swing.JFileChooser;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.JFileChooserDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JTextComponentFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JFileChooserFixture
extends ComponentFixture<JFileChooser>
implements CommonComponentFixture {
    private JFileChooserDriver driver;

    public JFileChooserFixture(Robot robot) {
        super(robot, JFileChooser.class);
        this.createDriver();
    }

    public JFileChooserFixture(Robot robot, JFileChooser target) {
        super(robot, target);
        this.createDriver();
    }

    public JFileChooserFixture(Robot robot, String labelName) {
        super(robot, labelName, JFileChooser.class);
        this.createDriver();
    }

    private void createDriver() {
        this.updateDriver(new JFileChooserDriver(this.robot));
    }

    final void updateDriver(JFileChooserDriver newDriver) {
        this.driver = newDriver;
    }

    public void approve() {
        this.driver.clickApproveButton((JFileChooser)this.target);
    }

    public JButtonFixture approveButton() {
        return new JButtonFixture(this.robot, this.driver.approveButton((JFileChooser)this.target));
    }

    public void cancel() {
        this.driver.clickCancelButton((JFileChooser)this.target);
    }

    public JButtonFixture cancelButton() {
        return new JButtonFixture(this.robot, this.driver.cancelButton((JFileChooser)this.target));
    }

    @Override
    public JFileChooserFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JFileChooserFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JFileChooserFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    public JTextComponentFixture fileNameTextBox() {
        return new JTextComponentFixture(this.robot, this.driver.fileNameTextBox((JFileChooser)this.target));
    }

    @Override
    public JFileChooserFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JFileChooserFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JFileChooserFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JFileChooserFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JFileChooserFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JFileChooserFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }

    @Override
    public JFileChooserFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    public JFileChooserFixture selectFile(File file) {
        this.driver.selectFile((JFileChooser)this.target, file);
        return this;
    }

    public JFileChooserFixture setCurrentDirectory(File dir) {
        this.driver.setCurrentDirectory((JFileChooser)this.target, dir);
        return this;
    }
}

