/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentLookupScope;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.Robot;
import org.fest.swing.fixture.DialogFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JFileChooserFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JListFixture;
import org.fest.swing.fixture.JMenuItemFinder;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JOptionPaneFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JPopupMenuInvokerFixture;
import org.fest.swing.fixture.JRadioButtonFixture;
import org.fest.swing.fixture.JScrollBarFixture;
import org.fest.swing.fixture.JScrollPaneFixture;
import org.fest.swing.fixture.JSliderFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JSplitPaneFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTableFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JToggleButtonFixture;
import org.fest.swing.fixture.JToolBarFixture;
import org.fest.swing.fixture.JTreeFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContainerFixture<T extends Container>
extends JPopupMenuInvokerFixture<T> {
    private final JMenuItemFinder menuItemFinder;

    public ContainerFixture(Robot robot, Class<? extends T> type) {
        super(robot, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target);
    }

    public ContainerFixture(Robot robot, String name, Class<? extends T> type) {
        super(robot, name, type);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target);
    }

    public ContainerFixture(Robot robot, T target) {
        super(robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)target);
    }

    public JButtonFixture button() {
        return new JButtonFixture(this.robot, this.findByType(JButton.class));
    }

    public JButtonFixture button(GenericTypeMatcher<? extends JButton> matcher) {
        return new JButtonFixture(this.robot, this.find(matcher));
    }

    public JButtonFixture button(String name) {
        return new JButtonFixture(this.robot, this.findByName(name, JButton.class));
    }

    public JCheckBoxFixture checkBox() {
        return new JCheckBoxFixture(this.robot, this.findByType(JCheckBox.class));
    }

    public JCheckBoxFixture checkBox(GenericTypeMatcher<? extends JCheckBox> matcher) {
        return new JCheckBoxFixture(this.robot, this.find(matcher));
    }

    public JCheckBoxFixture checkBox(String name) {
        return new JCheckBoxFixture(this.robot, this.findByName(name, JCheckBox.class));
    }

    public JComboBoxFixture comboBox() {
        return new JComboBoxFixture(this.robot, this.findByType(JComboBox.class));
    }

    public JComboBoxFixture comboBox(GenericTypeMatcher<? extends JComboBox> matcher) {
        return new JComboBoxFixture(this.robot, this.find(matcher));
    }

    public JComboBoxFixture comboBox(String name) {
        return new JComboBoxFixture(this.robot, this.findByName(name, JComboBox.class));
    }

    public DialogFixture dialog() {
        return new DialogFixture(this.robot, this.findByType(Dialog.class));
    }

    public DialogFixture dialog(GenericTypeMatcher<? extends Dialog> matcher) {
        return new DialogFixture(this.robot, this.find(matcher));
    }

    public DialogFixture dialog(String name) {
        return new DialogFixture(this.robot, this.findByName(name, Dialog.class));
    }

    public JFileChooserFixture fileChooser() {
        return new JFileChooserFixture(this.robot, this.findByType(JFileChooser.class));
    }

    public JFileChooserFixture fileChooser(GenericTypeMatcher<? extends JFileChooser> matcher) {
        return new JFileChooserFixture(this.robot, this.find(matcher));
    }

    public JFileChooserFixture fileChooser(String name) {
        return new JFileChooserFixture(this.robot, this.findByName(name, JFileChooser.class));
    }

    public JLabelFixture label() {
        return new JLabelFixture(this.robot, this.findByType(JLabel.class));
    }

    public JLabelFixture label(GenericTypeMatcher<? extends JLabel> matcher) {
        return new JLabelFixture(this.robot, this.find(matcher));
    }

    public JLabelFixture label(String name) {
        return new JLabelFixture(this.robot, this.findByName(name, JLabel.class));
    }

    public JListFixture list() {
        return new JListFixture(this.robot, this.findByType(JList.class));
    }

    public JListFixture list(GenericTypeMatcher<? extends JList> matcher) {
        return new JListFixture(this.robot, this.find(matcher));
    }

    public JListFixture list(String name) {
        return new JListFixture(this.robot, this.findByName(name, JList.class));
    }

    public JMenuItemFixture menuItemWithPath(String ... path) {
        return new JMenuItemFixture(this.robot, this.menuItemFinder.menuItemWithPath(path));
    }

    public JMenuItemFixture menuItem(String name) {
        boolean requireShowing = ComponentLookupScope.SHOWING_ONLY.equals((Object)this.robot.settings().componentLookupScope());
        return new JMenuItemFixture(this.robot, this.finder().findByName((Container)this.target, name, JMenuItem.class, requireShowing));
    }

    public JMenuItemFixture menuItem(GenericTypeMatcher<? extends JMenuItem> matcher) {
        return new JMenuItemFixture(this.robot, this.find(matcher));
    }

    public JOptionPaneFixture optionPane() {
        return new JOptionPaneFixture(this.robot);
    }

    public JPanelFixture panel() {
        return new JPanelFixture(this.robot, this.findByType(JPanel.class));
    }

    public JPanelFixture panel(GenericTypeMatcher<? extends JPanel> matcher) {
        return new JPanelFixture(this.robot, this.find(matcher));
    }

    public JPanelFixture panel(String name) {
        return new JPanelFixture(this.robot, this.findByName(name, JPanel.class));
    }

    public JRadioButtonFixture radioButton() {
        return new JRadioButtonFixture(this.robot, this.findByType(JRadioButton.class));
    }

    public JRadioButtonFixture radioButton(GenericTypeMatcher<? extends JRadioButton> matcher) {
        return new JRadioButtonFixture(this.robot, this.find(matcher));
    }

    public JRadioButtonFixture radioButton(String name) {
        return new JRadioButtonFixture(this.robot, this.findByName(name, JRadioButton.class));
    }

    public JScrollBarFixture scrollBar() {
        return new JScrollBarFixture(this.robot, this.findByType(JScrollBar.class));
    }

    public JScrollBarFixture scrollBar(GenericTypeMatcher<? extends JScrollBar> matcher) {
        return new JScrollBarFixture(this.robot, this.find(matcher));
    }

    public JScrollBarFixture scrollBar(String name) {
        return new JScrollBarFixture(this.robot, this.findByName(name, JScrollBar.class));
    }

    public JScrollPaneFixture scrollPane() {
        return new JScrollPaneFixture(this.robot, this.findByType(JScrollPane.class));
    }

    public JScrollPaneFixture scrollPane(GenericTypeMatcher<? extends JScrollPane> matcher) {
        return new JScrollPaneFixture(this.robot, this.find(matcher));
    }

    public JScrollPaneFixture scrollPane(String name) {
        return new JScrollPaneFixture(this.robot, this.findByName(name, JScrollPane.class));
    }

    public JSliderFixture slider() {
        return new JSliderFixture(this.robot, this.findByType(JSlider.class));
    }

    public JSliderFixture slider(GenericTypeMatcher<? extends JSlider> matcher) {
        return new JSliderFixture(this.robot, this.find(matcher));
    }

    public JSliderFixture slider(String name) {
        return new JSliderFixture(this.robot, this.findByName(name, JSlider.class));
    }

    public JSpinnerFixture spinner() {
        return new JSpinnerFixture(this.robot, this.findByType(JSpinner.class));
    }

    public JSpinnerFixture spinner(GenericTypeMatcher<? extends JSpinner> matcher) {
        return new JSpinnerFixture(this.robot, this.find(matcher));
    }

    public JSpinnerFixture spinner(String name) {
        return new JSpinnerFixture(this.robot, this.findByName(name, JSpinner.class));
    }

    public JSplitPaneFixture splitPane() {
        return new JSplitPaneFixture(this.robot, this.findByType(JSplitPane.class));
    }

    public JSplitPaneFixture splitPane(GenericTypeMatcher<? extends JSplitPane> matcher) {
        return new JSplitPaneFixture(this.robot, this.find(matcher));
    }

    public JSplitPaneFixture splitPane(String name) {
        return new JSplitPaneFixture(this.robot, this.findByName(name, JSplitPane.class));
    }

    public JTabbedPaneFixture tabbedPane() {
        return new JTabbedPaneFixture(this.robot, this.findByType(JTabbedPane.class));
    }

    public JTabbedPaneFixture tabbedPane(GenericTypeMatcher<? extends JTabbedPane> matcher) {
        return new JTabbedPaneFixture(this.robot, this.find(matcher));
    }

    public JTabbedPaneFixture tabbedPane(String name) {
        return new JTabbedPaneFixture(this.robot, this.findByName(name, JTabbedPane.class));
    }

    public JTableFixture table() {
        return new JTableFixture(this.robot, this.findByType(JTable.class));
    }

    public JTableFixture table(GenericTypeMatcher<? extends JTable> matcher) {
        return new JTableFixture(this.robot, this.find(matcher));
    }

    public JTableFixture table(String name) {
        return new JTableFixture(this.robot, this.findByName(name, JTable.class));
    }

    public JTextComponentFixture textBox() {
        return new JTextComponentFixture(this.robot, this.findByType(JTextComponent.class));
    }

    public JTextComponentFixture textBox(GenericTypeMatcher<? extends JTextComponent> matcher) {
        return new JTextComponentFixture(this.robot, this.find(matcher));
    }

    public JTextComponentFixture textBox(String name) {
        return new JTextComponentFixture(this.robot, this.findByName(name, JTextComponent.class));
    }

    public JToggleButtonFixture toggleButton() {
        return new JToggleButtonFixture(this.robot, this.findByType(JToggleButton.class));
    }

    public JToggleButtonFixture toggleButton(GenericTypeMatcher<? extends JToggleButton> matcher) {
        return new JToggleButtonFixture(this.robot, this.find(matcher));
    }

    public JToggleButtonFixture toggleButton(String name) {
        return new JToggleButtonFixture(this.robot, this.findByName(name, JToggleButton.class));
    }

    public JToolBarFixture toolBar() {
        return new JToolBarFixture(this.robot, this.findByType(JToolBar.class));
    }

    public JToolBarFixture toolBar(GenericTypeMatcher<? extends JToolBar> matcher) {
        return new JToolBarFixture(this.robot, this.find(matcher));
    }

    public JToolBarFixture toolBar(String name) {
        return new JToolBarFixture(this.robot, this.findByName(name, JToolBar.class));
    }

    public JTreeFixture tree() {
        return new JTreeFixture(this.robot, this.findByType(JTree.class));
    }

    public JTreeFixture tree(GenericTypeMatcher<? extends JTree> matcher) {
        return new JTreeFixture(this.robot, this.find(matcher));
    }

    public JTreeFixture tree(String name) {
        return new JTreeFixture(this.robot, this.findByName(name, JTree.class));
    }

    protected final <C extends Component> C findByType(Class<C> type) {
        return this.finder().findByType((Container)this.target, type, this.requireShowing());
    }

    protected final <C extends Component> C findByName(String name, Class<C> type) {
        return this.finder().findByName((Container)this.target, name, type, this.requireShowing());
    }

    protected final <C extends Component> C find(GenericTypeMatcher<? extends C> matcher) {
        return this.finder().find((Container)this.target, matcher);
    }

    protected final ComponentFinder finder() {
        return this.robot.finder();
    }
}

