/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.ColorFixture;
import org.fest.swing.fixture.ComponentFixtureValidator;
import org.fest.swing.fixture.FontFixture;
import org.fest.swing.format.Formatting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComponentFixture<T extends Component> {
    protected static final String FONT_PROPERTY = "font";
    protected static final String BACKGROUND_PROPERTY = "background";
    protected static final String FOREGROUND_PROPERTY = "foreground";
    public final Robot robot;
    public final T target;

    public ComponentFixture(Robot robot, Class<? extends T> type) {
        this(robot, ComponentFixture.findTarget(robot, type));
    }

    private static <C extends Component> C findTarget(Robot robot, Class<? extends C> type) {
        ComponentFixture.validate(robot, type);
        return robot.finder().findByType(type, ComponentFixture.requireShowing(robot));
    }

    public ComponentFixture(Robot robot, String name, Class<? extends T> type) {
        this(robot, ComponentFixture.findTarget(robot, name, type));
    }

    private static <C extends Component> C findTarget(Robot robot, String name, Class<? extends C> type) {
        ComponentFixture.validate(robot, type);
        return robot.finder().findByName(name, type, ComponentFixture.requireShowing(robot));
    }

    private static void validate(Robot robot, Class<?> type) {
        ComponentFixtureValidator.notNullRobot(robot);
        if (type == null) {
            throw new NullPointerException("The type of component to look for should not be null");
        }
    }

    protected boolean requireShowing() {
        return ComponentFixture.requireShowing(this.robot);
    }

    private static boolean requireShowing(Robot robot) {
        return robot.settings().componentLookupScope().requireShowing();
    }

    public ComponentFixture(Robot robot, T target) {
        this.robot = ComponentFixtureValidator.notNullRobot(robot);
        this.target = ComponentFixtureValidator.notNullTarget(target);
    }

    public final FontFixture font() {
        return new FontFixture(((Component)this.target).getFont(), ComponentDriver.propertyName(this.target, FONT_PROPERTY));
    }

    public final ColorFixture background() {
        return new ColorFixture(((Component)this.target).getBackground(), ComponentDriver.propertyName(this.target, BACKGROUND_PROPERTY));
    }

    public final ColorFixture foreground() {
        return new ColorFixture(((Component)this.target).getForeground(), ComponentDriver.propertyName(this.target, FOREGROUND_PROPERTY));
    }

    public final <C extends T> C targetCastedTo(Class<C> type) {
        Assertions.assertThat(this.target).as(Formatting.format(this.target)).isInstanceOf(type);
        return (C)((Component)type.cast(this.target));
    }

    public final T component() {
        return this.target;
    }
}

