/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.util.Platform;

public abstract class WindowLikeContainerDriver
extends ContainerDriver {
    private static final int MAXIMIZE_BUTTON_OFFSET = Platform.isOSX() ? 25 : (Platform.isWindows() ? -20 : 0);

    public WindowLikeContainerDriver(Robot robot) {
        super(robot);
    }

    protected final Point closeLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        if (Platform.isOSX()) {
            return new Point(insets.left + 15, insets.top / 2);
        }
        return new Point(size.width - insets.right - 10, insets.top / 2);
    }

    protected final Point iconifyLocation(Container c) {
        Insets insets = c.getInsets();
        Point p = new Point();
        p.y = insets.top / 2;
        if (Platform.isOSX()) {
            p.x = 35;
        }
        if (Platform.isWindows()) {
            int offset = Platform.isWindowsXP() ? 64 : 45;
            p.x = c.getSize().width - insets.right - offset;
        }
        return p;
    }

    protected final Point maximizeLocation(Container c) {
        Point p = this.iconifyLocation(c);
        p.x += MAXIMIZE_BUTTON_OFFSET;
        return p;
    }
}

