/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.fest.reflect.core.Reflection;
import org.fest.swing.cell.JTreeCellReader;
import org.fest.swing.core.Condition;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJTreeCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JTreeLocation;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public class JTreeDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTION_PROPERTY = "selection";
    private static final String SELECTION_PATH_PROPERTY = "selectionPath";
    private static final String SEPARATOR = "/";
    private final JTreeLocation location = new JTreeLocation();
    private JTreeCellReader cellReader;
    private String separator;

    public JTreeDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJTreeCellReader());
        this.separator(SEPARATOR);
    }

    public void toggleRow(JTree tree, int row) {
        if (!tree.isEnabled()) {
            return;
        }
        Point p = this.location.pointAt(tree, row);
        int toggleClickCount = tree.getToggleClickCount();
        if (toggleClickCount != 0) {
            this.robot.click(tree, p, MouseButton.LEFT_BUTTON, toggleClickCount);
            return;
        }
        TreeUI treeUI = tree.getUI();
        if (!(treeUI instanceof BasicTreeUI)) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Can't toggle row for ", treeUI}));
        }
        TreePath path = tree.getPathForLocation(p.x, p.y);
        Reflection.method((String)"toggleExpandState").withParameterTypes(new Class[]{TreePath.class}).in((Object)treeUI).invoke(new Object[]{path});
    }

    public void selectRows(final JTree tree, final int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of rows should not be null");
        }
        if (this.isEmptyArray(rows)) {
            throw new IllegalArgumentException("The array of rows should not be empty");
        }
        if (!tree.isEnabled()) {
            return;
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return rows.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectRow(tree, rows[index]);
            }
        }.multiSelect();
    }

    private boolean isEmptyArray(int[] array) {
        return array == null || array.length == 0;
    }

    public void selectRow(JTree tree, int row) {
        if (!tree.isEnabled()) {
            return;
        }
        this.selectPath(tree, this.location.pathFor(tree, row));
    }

    public void selectPaths(final JTree tree, final String[] paths) {
        if (Arrays.isEmpty((Object[])paths)) {
            throw ActionFailedException.actionFailure("The array of paths should not be null or empty");
        }
        if (!tree.isEnabled()) {
            return;
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return paths.length;
            }

            void selectElement(int index) {
                JTreeDriver.this.selectPath(tree, paths[index]);
            }
        }.multiSelect();
    }

    public void selectPath(JTree tree, String path) {
        if (!tree.isEnabled()) {
            return;
        }
        TreePath treePath = this.findMatchingPath(tree, path);
        this.selectPath(tree, treePath);
    }

    private void selectPath(JTree tree, TreePath path) {
        this.makeVisible(tree, path, false);
        Point p = this.location.pointAt(tree, path);
        int row = tree.getRowForLocation(p.x, p.y);
        if (this.alreadySelected(tree, row)) {
            return;
        }
        Rectangle rowBounds = tree.getRowBounds(row);
        this.scrollToVisible(tree, rowBounds);
        this.click((Component)tree, new Point(rowBounds.x + 1, rowBounds.y + rowBounds.height / 2));
    }

    private boolean alreadySelected(JTree tree, int row) {
        return tree.getLeadSelectionRow() == row && tree.getSelectionCount() == 1;
    }

    private boolean makeVisible(JTree tree, TreePath path, boolean expandWhenFound) {
        boolean changed = false;
        if (path.getPathCount() > 1) {
            changed = this.makeParentVisible(tree, path);
        }
        if (!expandWhenFound) {
            return changed;
        }
        this.expand(tree, path);
        this.waitForChildrenToShowUp(tree, path);
        return true;
    }

    private boolean makeParentVisible(JTree tree, TreePath path) {
        boolean changed = this.makeVisible(tree, path.getParentPath(), true);
        if (changed) {
            this.robot.waitForIdle();
        }
        return changed;
    }

    private void expand(JTree tree, TreePath path) {
        if (tree.isExpanded(path)) {
            return;
        }
        this.robot.invokeAndWait(new ExpandPathTask(tree, path));
    }

    private boolean waitForChildrenToShowUp(JTree tree, TreePath path) {
        try {
            Pause.pause((Condition)new UntilChildrenShowUp(tree, path, path.toString()), this.robot.settings().timeoutToBeVisible());
        }
        catch (WaitTimedOutError e) {
            throw new LocationUnavailableException(e.getMessage());
        }
        return true;
    }

    public JPopupMenu showPopupMenu(JTree tree, int row) {
        return this.robot.showPopupMenu(tree, this.location.pointAt(tree, row));
    }

    public JPopupMenu showPopupMenu(JTree tree, String path) {
        return this.robot.showPopupMenu(tree, this.location.pointAt(tree, this.findMatchingPath(tree, path)));
    }

    public void drag(JTree tree, int row) {
        this.drag(tree, this.location.pathFor(tree, row));
    }

    public void drop(JTree tree, int row) {
        this.drop(tree, this.location.pathFor(tree, row));
    }

    public void drag(JTree tree, String path) {
        this.drag(tree, this.findMatchingPath(tree, path));
    }

    public void drop(JTree tree, String path) {
        this.drop(tree, this.findMatchingPath(tree, path));
    }

    private void drag(JTree tree, TreePath path) {
        this.selectPath(tree, path);
        this.drag((Component)tree, this.location.pointAt(tree, path));
    }

    private void drop(JTree tree, TreePath path) {
        this.scrollToVisible(tree, tree.getPathBounds(path));
        this.drop((Component)tree, this.location.pointAt(tree, path));
    }

    public void requireSelection(JTree tree, int[] rows) {
        if (rows == null) {
            throw new NullPointerException("The array of row indices should not be null");
        }
        for (int row : rows) {
            this.requireSelection(tree, tree.getPathForRow(row));
        }
    }

    public void requireSelection(JTree tree, String[] paths) {
        if (paths == null) {
            throw new NullPointerException("The array of paths should not be null");
        }
        for (String path : paths) {
            this.requireSelection(tree, this.findMatchingPath(tree, path));
        }
    }

    private void requireSelection(JTree tree, TreePath path) {
        if (tree.getSelectionCount() == 0) {
            Fail.fail((String)Strings.concat((Object[])new Object[]{"[", JTreeDriver.propertyName(tree, SELECTION_PROPERTY), "] No selection"}));
        }
        Assertions.assertThat((Object)tree.getSelectionPath()).as(JTreeDriver.propertyName(tree, SELECTION_PATH_PROPERTY)).isEqualTo((Object)path);
    }

    public void requireNoSelection(JTree tree) {
        if (tree.getSelectionCount() == 0) {
            return;
        }
        String message = Strings.concat((Object[])new Object[]{"[", JTreeDriver.propertyName(tree, SELECTION_PROPERTY), "] expected no selection but was:<", Arrays.format((Object)tree.getSelectionPaths()), ">"});
        Fail.fail((String)message);
    }

    public void requireEditable(JTree tree) {
        Assertions.assertThat((boolean)tree.isEditable()).as(JTreeDriver.editableProperty(tree)).isTrue();
    }

    public void requireNotEditable(JTree tree) {
        Assertions.assertThat((boolean)tree.isEditable()).as(JTreeDriver.editableProperty(tree)).isFalse();
    }

    private static String editableProperty(JTree tree) {
        return JTreeDriver.propertyName(tree, EDITABLE_PROPERTY);
    }

    private TreePath findMatchingPath(JTree tree, String path) {
        String[] pathStrings = this.splitPath(path);
        TreeModel model = tree.getModel();
        ArrayList<Object> newPathValues = new ArrayList<Object>(pathStrings.length + 1);
        Object node = model.getRoot();
        int pathElementCount = pathStrings.length;
        for (int stringIndex = 0; stringIndex < pathElementCount; ++stringIndex) {
            String pathString = pathStrings[stringIndex];
            Object match = null;
            if (stringIndex == 0 && tree.isRootVisible()) {
                if (!pathString.equals(this.value(tree, node))) {
                    throw this.pathNotFound(path);
                }
                newPathValues.add(node);
                continue;
            }
            int childCount = model.getChildCount(node);
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                Object child = model.getChild(node, childIndex);
                if (!pathString.equals(this.value(tree, child))) continue;
                if (match != null) {
                    throw this.multipleMatchingNodes(pathString, this.value(tree, node));
                }
                match = child;
            }
            if (match == null) {
                throw this.pathNotFound(path);
            }
            newPathValues.add(match);
            node = match;
        }
        return new TreePath(newPathValues.toArray());
    }

    private LocationUnavailableException pathNotFound(String path) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find path ", Strings.quote((String)path)}));
    }

    private String[] splitPath(String path) {
        ArrayList<String> result = new ArrayList<String>();
        int separatorSize = this.separator.length();
        int index = 0;
        int pathSize = path.length();
        while (index < pathSize) {
            int separatorPosition = path.indexOf(this.separator, index);
            if (separatorPosition == -1) {
                separatorPosition = pathSize;
            }
            result.add(path.substring(index, separatorPosition));
            index = separatorPosition + separatorSize;
        }
        return result.toArray(new String[result.size()]);
    }

    private LocationUnavailableException multipleMatchingNodes(String matchingText, Object parentText) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"There is more than one node with value ", Strings.quote((String)matchingText), " under ", Strings.quote((Object)parentText)}));
    }

    private String value(JTree tree, Object modelValue) {
        return this.cellReader.valueAt(tree, modelValue);
    }

    public String separator() {
        return this.separator;
    }

    public void separator(String newSeparator) {
        if (newSeparator == null) {
            throw new NullPointerException("The path separator should not be null");
        }
        this.separator = newSeparator;
    }

    public void cellReader(JTreeCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }

    private static class UntilChildrenShowUp
    extends Condition {
        private final JTree tree;
        private final Object lastInPath;

        UntilChildrenShowUp(JTree tree, TreePath path, String pathDescription) {
            super(Strings.concat((Object[])new Object[]{pathDescription, " to show"}));
            this.tree = tree;
            this.lastInPath = path.getLastPathComponent();
        }

        public boolean test() {
            return this.tree.getModel().getChildCount(this.lastInPath) != 0;
        }
    }

    private static class ExpandPathTask
    implements Runnable {
        private final JTree target;
        private final TreePath path;

        ExpandPathTask(JTree target, TreePath path) {
            this.target = target;
            this.path = path;
        }

        public void run() {
            this.target.expandPath(this.path);
        }
    }
}

