/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JToolBar;
import org.fest.util.Arrays;
import org.fest.util.Strings;

public final class JToolBarLocation {
    private static String[] VALID_CONSTRAINTS = new String[]{"North", "East", "South", "West"};

    public Point pointToGrab(JToolBar toolBar) {
        Insets insets = toolBar.getInsets();
        if (Math.max(Math.max(Math.max(insets.left, insets.top), insets.right), insets.bottom) == insets.left) {
            return new Point(insets.left / 2, toolBar.getHeight() / 2);
        }
        if (Math.max(Math.max(insets.top, insets.right), insets.bottom) == insets.top) {
            return new Point(toolBar.getWidth() / 2, insets.top / 2);
        }
        if (Math.max(insets.right, insets.bottom) == insets.right) {
            return new Point(toolBar.getWidth() - insets.right / 2, toolBar.getHeight() / 2);
        }
        return new Point(toolBar.getWidth() / 2, toolBar.getHeight() - insets.bottom / 2);
    }

    public Point dockLocation(JToolBar toolBar, Container dock, String constraint) {
        int offset;
        this.validate(constraint);
        Insets insets = dock.getInsets();
        int n = offset = this.isHorizontal(toolBar) ? toolBar.getHeight() : toolBar.getWidth();
        if ("North".equals(constraint)) {
            return new Point(dock.getWidth() / 2, insets.top);
        }
        if ("East".equals(constraint)) {
            return new Point(dock.getWidth() - insets.right - 1, this.verticalDockingYCoordinate(dock, insets, offset));
        }
        if ("West".equals(constraint)) {
            return new Point(insets.left, this.verticalDockingYCoordinate(dock, insets, offset));
        }
        int x = dock.getWidth() / 2;
        if (x < insets.left + offset) {
            x = insets.left + offset;
        } else if (x > dock.getWidth() - insets.right - offset - 1) {
            x = dock.getWidth() - insets.right - offset - 1;
        }
        return new Point(x, dock.getHeight() - insets.bottom - 1);
    }

    private void validate(String constraint) {
        for (String validConstraint : VALID_CONSTRAINTS) {
            if (!validConstraint.equals(constraint)) continue;
            return;
        }
        throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{Strings.quote((String)constraint), " is not a valid constraint. Valid constraints are ", Arrays.format((Object)VALID_CONSTRAINTS)}));
    }

    private boolean isHorizontal(JToolBar toolBar) {
        return toolBar.getOrientation() == 0;
    }

    private int verticalDockingYCoordinate(Container dock, Insets insets, int offset) {
        int y = dock.getHeight() / 2;
        if (y < insets.top + offset) {
            y = insets.top + offset;
        }
        return y;
    }
}

