/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.AbstractJTableCellWriter;
import org.fest.swing.driver.CancelTableCellEditingTask;
import org.fest.swing.driver.JTextComponentDriver;
import org.fest.swing.driver.WaitForComponentToShowCondition;

public class JTableTextComponentEditorCellWriter
extends AbstractJTableCellWriter {
    private final JTextComponentDriver driver;

    public JTableTextComponentEditorCellWriter(Robot robot) {
        super(robot);
        this.driver = new JTextComponentDriver(robot);
    }

    public void enterValue(JTable table, int row, int column, String value) {
        JTextComponent editor = this.editor(table, row, column);
        this.startCellEditing(table, row, column);
        this.driver.replaceText(editor, value);
        this.stopEditing(editor);
    }

    public void startCellEditing(JTable table, int row, int column) {
        JTextComponent editor = this.editor(table, row, column);
        this.clickCell(table, row, column, 2);
        Pause.pause(new WaitForComponentToShowCondition(editor));
    }

    public void stopCellEditing(JTable table, int row, int column) {
        this.stopEditing(this.editor(table, row, column));
    }

    private void stopEditing(JTextComponent editor) {
        this.driver.pressAndReleaseKeys(editor, 10);
    }

    public void cancelCellEditing(JTable table, int row, int column) {
        this.editor(table, row, column);
        this.robot.invokeAndWait(new CancelTableCellEditingTask(table, row, column));
    }

    private JTextComponent editor(JTable table, int row, int column) {
        Component editor = this.editorForCell(table, row, column);
        if (editor instanceof JTextComponent) {
            return (JTextComponent)editor;
        }
        throw this.cannotHandleEditor(editor);
    }
}

