/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import javax.swing.JScrollBar;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JScrollBarLocation;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class JScrollBarDriver
extends JComponentDriver {
    private static final String VALUE_PROPERTY = "value";
    private final JScrollBarLocation location = new JScrollBarLocation();

    public JScrollBarDriver(Robot robot) {
        super(robot);
    }

    public void scrollUnitUp(JScrollBar scrollBar) {
        this.scrollUnitUp(scrollBar, 1);
    }

    public void scrollUnitUp(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll up one unit");
        Point where = this.location.unitLocationToScrollUp(scrollBar);
        this.scroll(scrollBar, where, times * scrollBar.getUnitIncrement());
    }

    public void scrollUnitDown(JScrollBar scrollBar) {
        this.scrollUnitDown(scrollBar, 1);
    }

    public void scrollUnitDown(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll down one unit");
        Point where = this.location.unitLocationToScrollDown(scrollBar);
        this.scroll(scrollBar, where, times * scrollBar.getUnitIncrement() * -1);
    }

    public void scrollBlockUp(JScrollBar scrollBar) {
        this.scrollBlockUp(scrollBar, 1);
    }

    public void scrollBlockUp(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll up one block");
        Point where = this.location.blockLocationToScrollUp(scrollBar);
        this.scroll(scrollBar, where, times * scrollBar.getBlockIncrement());
    }

    public void scrollBlockDown(JScrollBar scrollBar) {
        this.scrollBlockDown(scrollBar, 1);
    }

    public void scrollBlockDown(JScrollBar scrollBar, int times) {
        this.validateTimes(times, "scroll down one block");
        Point where = this.location.blockLocationToScrollDown(scrollBar);
        this.scroll(scrollBar, where, times * scrollBar.getBlockIncrement() * -1);
    }

    private void validateTimes(int times, String action) {
        if (times > 0) {
            return;
        }
        String message = Strings.concat((Object[])new Object[]{"The number of times to ", action, " should be greater than zero, but was <", String.valueOf(times), ">"});
        throw ActionFailedException.actionFailure(message);
    }

    private void scroll(JScrollBar scrollBar, Point where, int count) {
        if (!scrollBar.isEnabled()) {
            return;
        }
        this.robot.moveMouse(scrollBar, where.x, where.y);
        int value = scrollBar.getValue() + count;
        this.setValueProperty(scrollBar, value);
    }

    public void scrollTo(JScrollBar scrollBar, int position) {
        this.validatePosition(scrollBar, position);
        if (!scrollBar.isEnabled()) {
            return;
        }
        Point thumb = this.location.thumbLocation(scrollBar, scrollBar.getValue());
        this.robot.moveMouse(scrollBar, thumb.x, thumb.y);
        thumb = this.location.thumbLocation(scrollBar, position);
        this.robot.moveMouse(scrollBar, thumb.x, thumb.y);
        this.setValueProperty(scrollBar, position);
    }

    private void validatePosition(JScrollBar scrollBar, int position) {
        int min = scrollBar.getMinimum();
        int max = scrollBar.getMaximum();
        if (position >= min && position <= max) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Position <", String.valueOf(position), "> is not within the JScrollBar bounds of <", String.valueOf(min), "> and <", String.valueOf(max), ">"}));
    }

    private void setValueProperty(JScrollBar scrollBar, int value) {
        this.robot.invokeLater(scrollBar, new SetValueTask(scrollBar, value));
        this.robot.waitForIdle();
    }

    public void requireValue(JScrollBar scrollBar, int value) {
        Assertions.assertThat((int)scrollBar.getValue()).as(JScrollBarDriver.propertyName(scrollBar, VALUE_PROPERTY)).isEqualTo(value);
    }

    private static class SetValueTask
    implements Runnable {
        private final JScrollBar target;
        private final int value;

        SetValueTask(JScrollBar target, int value) {
            this.target = target;
            this.value = value;
        }

        public void run() {
            this.target.setValue(this.value);
        }
    }
}

