/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.core.ComponentMatcher;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class JMenuItemMatcher
implements ComponentMatcher {
    private static final String SEPARATOR = "|";
    private final String label;

    public JMenuItemMatcher(String ... path) {
        this.label = Strings.join((String[])path).with(SEPARATOR);
    }

    public boolean matches(Component c) {
        if (!(c instanceof JMenuItem)) {
            return false;
        }
        JMenuItem menuItem = (JMenuItem)c;
        String text = menuItem.getText();
        return Objects.areEqual((Object)this.label, (Object)text) || Objects.areEqual((Object)this.label, (Object)this.pathOf(menuItem));
    }

    private String pathOf(JMenuItem menuItem) {
        Component parent = this.parentOf(menuItem);
        if (parent instanceof JMenuItem) {
            return Strings.concat((Object[])new Object[]{this.pathOf((JMenuItem)parent), SEPARATOR, menuItem.getText()});
        }
        return menuItem.getText();
    }

    private Component parentOf(JMenuItem menuItem) {
        Component parent = menuItem.getParent();
        if (parent instanceof JPopupMenu) {
            parent = ((JPopupMenu)parent).getInvoker();
        }
        return parent;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "label=", Strings.quote((String)this.label), "]"});
    }
}

