/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.util.Strings;

public class JFileChooserDriver
extends JComponentDriver {
    public JFileChooserDriver(Robot robot) {
        super(robot);
    }

    public void selectFile(JFileChooser fileChooser, File file) {
        int mode = fileChooser.getFileSelectionMode();
        boolean isFolder = file.isDirectory();
        if (mode == 0 && isFolder) {
            throw this.cannotSelectFile(file, "the file chooser cannot open directories");
        }
        if (mode == 1 && !isFolder) {
            throw this.cannotSelectFile(file, "the file chooser can only open directories");
        }
        this.robot.invokeAndWait(new SelectFileTask(fileChooser, file));
    }

    private ActionFailedException cannotSelectFile(File file, String reason) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to select file ", file, ": ", reason}));
    }

    public void setCurrentDirectory(JFileChooser fileChooser, File dir) {
        this.robot.invokeAndWait(new SetCurrentDirectoryTask(fileChooser, dir));
    }

    public JTextField fileNameTextBox(JFileChooser fileChooser) {
        return this.robot.finder().findByType(fileChooser, JTextField.class);
    }

    public void clickCancelButton(JFileChooser fileChooser) {
        this.clickButton(this.cancelButton(fileChooser));
    }

    public JButton cancelButton(JFileChooser fileChooser) {
        String buttonText = UIManager.getString("FileChooser.cancelButtonText");
        JButton cancelButton = this.findButton(fileChooser, buttonText);
        if (cancelButton == null) {
            throw this.cannotFindButton("Cancel", buttonText);
        }
        return cancelButton;
    }

    public void clickApproveButton(JFileChooser fileChooser) {
        this.clickButton(this.approveButton(fileChooser));
    }

    public JButton approveButton(JFileChooser fileChooser) {
        String buttonText = this.approveButtonText(fileChooser);
        JButton approveButton = this.findButton(fileChooser, buttonText);
        if (approveButton == null) {
            throw this.cannotFindButton("Approve", buttonText);
        }
        return approveButton;
    }

    private String approveButtonText(JFileChooser fileChooser) {
        String text = fileChooser.getApproveButtonText();
        if (Strings.isEmpty((String)text)) {
            text = fileChooser.getUI().getApproveButtonText(fileChooser);
        }
        return text;
    }

    private JButton findButton(JFileChooser fileChooser, String text) {
        return this.robot.finder().find((Container)fileChooser, new JButtonMatcher(text, true));
    }

    private ComponentLookupException cannotFindButton(String name, String text) {
        throw new ComponentLookupException(Strings.concat((Object[])new Object[]{"Unable to find ", Strings.quote((String)name), " button with text ", Strings.quote((String)text)}));
    }

    private void clickButton(JButton button) {
        this.requireEnabled(button);
        this.click(button);
    }

    private static class SetCurrentDirectoryTask
    implements Runnable {
        private final JFileChooser fileChooser;
        private final File dir;

        SetCurrentDirectoryTask(JFileChooser fileChooser, File dir) {
            this.fileChooser = fileChooser;
            this.dir = dir;
        }

        public void run() {
            this.fileChooser.setCurrentDirectory(this.dir);
        }
    }

    private static class SelectFileTask
    implements Runnable {
        private final JFileChooser fileChooser;
        private final File file;

        SelectFileTask(JFileChooser fileChooser, File file) {
            this.fileChooser = fileChooser;
            this.file = file;
        }

        public void run() {
            this.fileChooser.setSelectedFile(this.file);
        }
    }
}

