/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.driver.BasicJComboBoxCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListDriver;
import org.fest.swing.driver.SetSelectedIndexTask;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class JComboBoxDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListDriver listDriver;
    private JComboBoxCellReader cellReader;
    private static final ComponentMatcher LIST_MATCHER = new TypeMatcher(JList.class);

    public JComboBoxDriver(Robot robot) {
        super(robot);
        this.listDriver = new JListDriver(robot);
        this.cellReader(new BasicJComboBoxCellReader());
    }

    public String[] contentsOf(JComboBox comboBox) {
        int itemCount = this.size(comboBox);
        String[] items = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            items[i] = this.value(comboBox, i);
        }
        return items;
    }

    public void selectItem(JComboBox comboBox, String value) {
        int itemCount = this.size(comboBox);
        for (int i = 0; i < itemCount; ++i) {
            if (!Objects.areEqual((Object)this.value(comboBox, i), (Object)value)) continue;
            this.selectItem(comboBox, i);
            return;
        }
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find item ", Strings.quote((String)value), " among the JComboBox contents (", Arrays.format((Object)this.contentsOf(comboBox)), ")"}));
    }

    public void requireSelection(JComboBox comboBox, String value) {
        int selectedIndex = comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(comboBox), "] No selection"}));
        }
        Assertions.assertThat((String)this.value(comboBox, selectedIndex)).as(this.selectedIndexProperty(comboBox)).isEqualTo(value);
    }

    public void requireNoSelection(JComboBox comboBox) {
        Assertions.assertThat((int)comboBox.getSelectedIndex()).as(this.selectedIndexProperty(comboBox)).isEqualTo(-1);
    }

    public String value(JComboBox comboBox, int index) {
        this.validateIndex(comboBox, index);
        return this.cellReader.valueAt(comboBox, index);
    }

    private String selectedIndexProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, SELECTED_INDEX_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItem(JComboBox comboBox, int index) {
        int validatedIndex = this.validateIndex(comboBox, index);
        if (!comboBox.isEnabled()) {
            return;
        }
        this.showDropDownList(comboBox);
        try {
            this.listDriver.selectItem(this.dropDownList(), validatedIndex);
        }
        catch (ComponentLookupException e) {
            this.robot.invokeAndWait(new SetSelectedIndexTask(comboBox, validatedIndex));
        }
        finally {
            this.hideDropDownListIfVisible(comboBox);
        }
    }

    int validateIndex(JComboBox comboBox, int index) {
        int itemCount = this.size(comboBox);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{"Item index (", String.valueOf(index), ") should be between [0] and [", String.valueOf(itemCount - 1), "] (inclusive)"}));
    }

    private int size(JComboBox comboBox) {
        return comboBox.getItemCount();
    }

    void showDropDownList(final JComboBox comboBox) {
        if (this.isDropDownVisible(comboBox) || !comboBox.isEnabled()) {
            return;
        }
        this.robot.invokeAndWait(new Runnable(){

            public void run() {
                JComboBoxDriver.this.dropDownVisibleThroughUIDelegate(comboBox, true);
            }
        });
    }

    private void hideDropDownListIfVisible(final JComboBox comboBox) {
        if (!this.isDropDownVisible(comboBox)) {
            return;
        }
        this.robot.invokeAndWait(new Runnable(){

            public void run() {
                JComboBoxDriver.this.dropDownVisibleThroughUIDelegate(comboBox, false);
            }
        });
    }

    boolean isDropDownVisible(JComboBox comboBox) {
        return comboBox.getUI().isPopupVisible(comboBox);
    }

    void dropDownVisibleThroughUIDelegate(JComboBox comboBox, boolean visible) {
        comboBox.getUI().setPopupVisible(comboBox, visible);
    }

    public void replaceText(JComboBox comboBox, String text) {
        if (!this.canAccessEditorIn(comboBox)) {
            return;
        }
        this.selectAllText(comboBox);
        this.enterText(comboBox, text);
    }

    public void selectAllText(JComboBox comboBox) {
        if (!this.canAccessEditorIn(comboBox)) {
            return;
        }
        Component editor = comboBox.getEditor().getEditorComponent();
        if (!(editor instanceof JComponent)) {
            return;
        }
        this.focus(editor);
        this.invokeAction((JComponent)editor, "select-all");
    }

    public void enterText(JComboBox comboBox, String text) {
        if (!this.canAccessEditorIn(comboBox)) {
            return;
        }
        this.focus(comboBox);
        this.robot.enterText(text);
    }

    private boolean canAccessEditorIn(JComboBox comboBox) {
        return comboBox.isEditable() && comboBox.isEnabled();
    }

    public JList dropDownList() {
        JList list;
        JPopupMenu popup = this.robot.findActivePopupMenu();
        if (popup == null) {
            TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(this.robot.settings().timeoutToFindPopup());
            while ((popup = this.robot.findActivePopupMenu()) == null) {
                if (watch.isTimeOut()) {
                    throw this.listNotFound();
                }
                Pause.pause();
            }
        }
        if ((list = this.findListIn(popup)) == null) {
            throw this.listNotFound();
        }
        return list;
    }

    private ComponentLookupException listNotFound() {
        throw new ComponentLookupException("Unable to find the pop-up list for the JComboBox");
    }

    private JList findListIn(Container parent) {
        try {
            return (JList)this.robot.finder().find(LIST_MATCHER);
        }
        catch (ComponentLookupException ignored) {
            return null;
        }
    }

    public void requireEditable(JComboBox comboBox) {
        Assertions.assertThat((boolean)comboBox.isEditable()).as(JComboBoxDriver.editableProperty(comboBox)).isTrue();
    }

    public void requireNotEditable(JComboBox comboBox) {
        Assertions.assertThat((boolean)comboBox.isEditable()).as(JComboBoxDriver.editableProperty(comboBox)).isFalse();
    }

    private static String editableProperty(JComboBox comboBox) {
        return JComboBoxDriver.propertyName(comboBox, EDITABLE_PROPERTY);
    }

    public void cellReader(JComboBoxCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }
}

