/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import org.fest.swing.core.Condition;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.WindowDriver;
import org.fest.swing.exception.ActionFailedException;

public class FrameDriver
extends WindowDriver {
    public FrameDriver(Robot robot) {
        super(robot);
    }

    public void iconify(Frame frame) {
        Point p = this.iconifyLocation(frame);
        if (p != null) {
            this.robot.moveMouse(frame, p.x, p.y);
        }
        this.updateFrameExtendedState(frame, 1);
        Pause.pause(new UntilIconified(frame));
    }

    public void deiconify(Frame frame) {
        this.updateFrameExtendedState(frame, 0);
        Pause.pause(new UntilDeiconified(frame));
    }

    public void normalize(Frame frame) {
        this.updateFrameExtendedState(frame, 0);
        Pause.pause(new UntilNormalized(frame));
    }

    public void maximize(Frame frame) {
        Point p = this.maximizeLocation(frame);
        if (p != null) {
            this.robot.moveMouse(frame, p.x, p.y);
        }
        if (!this.supportsMaximize()) {
            throw ActionFailedException.actionFailure("Platform does not support maximizing frames");
        }
        this.updateFrameExtendedState(frame, 6);
        Pause.pause(new UntilMaximized(frame));
    }

    private void updateFrameExtendedState(Frame frame, int state) {
        this.robot.invokeLater(frame, new SetExtendedStateTask(frame, state));
    }

    private boolean supportsMaximize() {
        return Toolkit.getDefaultToolkit().isFrameStateSupported(6);
    }

    private static class SetExtendedStateTask
    implements Runnable {
        private final Frame target;
        private final int state;

        SetExtendedStateTask(Frame target, int state) {
            this.target = target;
            this.state = state;
        }

        public void run() {
            this.target.setExtendedState(this.state);
        }
    }

    private static class UntilMaximized
    extends Condition {
        private final Frame target;

        UntilMaximized(Frame target) {
            super("frame being maximized");
            this.target = target;
        }

        public boolean test() {
            return (this.target.getExtendedState() & 6) == 6;
        }
    }

    private static class UntilNormalized
    extends Condition {
        private final Frame target;

        UntilNormalized(Frame target) {
            super("frame being normalized");
            this.target = target;
        }

        public boolean test() {
            return this.target.getExtendedState() == 0;
        }
    }

    private static class UntilDeiconified
    extends Condition {
        private final Frame target;

        UntilDeiconified(Frame target) {
            super("frame being deiconified");
            this.target = target;
        }

        public boolean test() {
            return this.target.getExtendedState() != 1;
        }
    }

    private static class UntilIconified
    extends Condition {
        private final Frame target;

        UntilIconified(Frame target) {
            super("frame being iconified");
            this.target = target;
        }

        public boolean test() {
            return this.target.getExtendedState() == 1;
        }
    }
}

