/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.driver.SetLocationTask;
import org.fest.swing.driver.SetSizeTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.swing.util.AWT;
import org.fest.util.Strings;

public abstract class ContainerDriver
extends ComponentDriver {
    public ContainerDriver(Robot robot) {
        super(robot);
    }

    public void resize(Container c, int width, int height) {
        Dimension size = c.getSize();
        this.resizeBy(c, width - size.width, height - size.height);
    }

    protected void resizeBy(Container c, int horizontally, int vertically) {
        this.simulateResizeStarted(c, horizontally, vertically);
        Dimension size = new Dimension(c.getWidth() + horizontally, c.getHeight() + vertically);
        this.robot.invokeAndWait(c, new SetSizeTask(c, size));
        this.simulateResizeComplete(c);
        this.robot.waitForIdle();
    }

    private void simulateResizeStarted(Container c, int horizontally, int vertically) {
        if (!this.isUserResizable(c)) {
            return;
        }
        Point p = this.resizeLocationOf(c);
        this.robot.moveMouse(c, p.x, p.y);
        this.robot.moveMouse(c, p.x + horizontally, p.y + vertically);
    }

    private void simulateResizeComplete(Container c) {
        if (!this.isUserResizable(c)) {
            return;
        }
        Point p = this.resizeLocationOf(c);
        this.robot.moveMouse(c, p.x, p.y);
    }

    protected Point resizeLocationOf(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        return new Point(size.width - insets.right / 2, size.height - insets.bottom / 2);
    }

    public void move(Container c, int x, int y) {
        Point onScreen = AWT.locationOnScreenOf(c);
        if (onScreen == null) {
            throw this.componentNotShowingOnScreen(c);
        }
        this.moveBy(c, x - onScreen.x, y - onScreen.y);
    }

    protected void moveBy(Container c, int horizontally, int vertically) {
        Point onScreen = AWT.locationOnScreenOf(c);
        if (onScreen == null) {
            throw this.componentNotShowingOnScreen(c);
        }
        this.simulateMoveStarted(c, horizontally, vertically);
        Point location = new Point(onScreen.x + horizontally, onScreen.y + vertically);
        this.robot.invokeAndWait(c, new SetLocationTask(c, location));
        this.simulateMoveComplete(c);
        this.robot.waitForIdle();
    }

    private ActionFailedException componentNotShowingOnScreen(Container c) {
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"The component ", Formatting.format(c), " is not showing on the screen"}));
    }

    private void simulateMoveStarted(Container c, int horizontally, int vertically) {
        if (!this.isUserMovable(c)) {
            return;
        }
        Point p = this.moveLocation(c);
        this.robot.moveMouse(c, p.x, p.y);
        this.robot.moveMouse(c, p.x + horizontally, p.y + vertically);
    }

    private void simulateMoveComplete(Container c) {
        if (!this.isUserMovable(c)) {
            return;
        }
        Point p = this.moveLocation(c);
        this.robot.moveMouse(c, p.x, p.y);
    }

    protected Point moveLocation(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        return new Point(size.width / 2, insets.top / 2);
    }
}

