/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.AbstractButton;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;

public class AbstractButtonDriver
extends JComponentDriver {
    private static final String SELECTED_PROPERTY = "selected";
    private static final String TEXT_PROPERTY = "text";

    public AbstractButtonDriver(Robot robot) {
        super(robot);
    }

    public void requireText(AbstractButton button, String expected) {
        Assertions.assertThat((String)button.getText()).as(AbstractButtonDriver.propertyName(button, TEXT_PROPERTY)).isEqualTo(expected);
    }

    public void select(AbstractButton button) {
        if (button.isSelected()) {
            return;
        }
        this.click(button);
    }

    public void unselect(AbstractButton button) {
        if (!button.isSelected()) {
            return;
        }
        this.click(button);
    }

    public void requireSelected(AbstractButton button) {
        Assertions.assertThat((boolean)button.isSelected()).as(AbstractButtonDriver.selectedProperty(button)).isTrue();
    }

    public void requireNotSelected(AbstractButton button) {
        Assertions.assertThat((boolean)button.isSelected()).as(AbstractButtonDriver.selectedProperty(button)).isFalse();
    }

    private static String selectedProperty(AbstractButton button) {
        return AbstractButtonDriver.propertyName(button, SELECTED_PROPERTY);
    }
}

