/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import org.fest.swing.hierarchy.ComponentHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SingleComponentHierarchy
implements ComponentHierarchy {
    private final Container root;
    private final List<Container> list = new ArrayList<Container>();
    private final ComponentHierarchy hierarchy;

    public SingleComponentHierarchy(Container root, ComponentHierarchy hierarchy) {
        this.root = root;
        this.hierarchy = hierarchy;
        this.list.add(root);
    }

    Container root() {
        return this.root;
    }

    @Override
    public Container parentOf(Component c) {
        return this.hierarchy.parentOf(c);
    }

    @Override
    public Collection<? extends Container> roots() {
        return this.list;
    }

    @Override
    public Collection<Component> childrenOf(Component c) {
        return this.hierarchy.childrenOf(c);
    }

    @Override
    public boolean contains(Component c) {
        return this.hierarchy.contains(c) && SwingUtilities.isDescendingFrom(c, this.root);
    }

    @Override
    public void dispose(Window w) {
        this.hierarchy.dispose(w);
    }
}

