/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Robot;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.util.AWT;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

class RobotEventGenerator
implements InputEventGenerator {
    private static final int KEY_INPUT_DELAY = 200;
    private final Robot robot;
    private final Settings settings;

    RobotEventGenerator(Settings settings) throws AWTException {
        this.settings = settings;
        this.robot = new Robot();
        settings.attachTo(this.robot);
        if (Platform.isWindows() || Platform.isOSX()) {
            Pause.pause(500L);
        }
    }

    Robot robot() {
        return this.robot;
    }

    public void pressMouse(Component c, Point where, int buttons) {
        this.moveMouse(c, where.x, where.y);
        this.pressMouse(buttons);
    }

    public void pressMouse(int buttons) {
        this.robot.mousePress(buttons);
    }

    public void releaseMouse(int buttons) {
        this.robot.mouseRelease(buttons);
    }

    public void moveMouse(Component c, int x, int y) {
        try {
            Point point = AWT.locationOnScreenOf(c);
            if (point == null) {
                return;
            }
            point.translate(x, y);
            this.robot.mouseMove(point.x, point.y);
        }
        catch (IllegalComponentStateException e) {
            throw UnexpectedException.unexpected(e);
        }
    }

    public void pressKey(int keyCode, char keyChar) {
        try {
            this.robot.keyPress(keyCode);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Strings.concat((Object[])new Object[]{"Invalid key code '", String.valueOf(keyCode), "'"}));
        }
    }

    public void releaseKey(int keyCode) {
        this.robot.keyRelease(keyCode);
        if (!Platform.isOSX()) {
            return;
        }
        int delayBetweenEvents = this.settings.delayBetweenEvents();
        if (200 > delayBetweenEvents) {
            Pause.pause(200 - delayBetweenEvents);
        }
    }
}

