/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.util.concurrent.TimeUnit;
import org.fest.swing.core.Condition;
import org.fest.swing.core.Timeout;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.util.TimeoutWatch;
import org.fest.util.Strings;

public final class Pause {
    private static final int DEFAULT_DELAY = 30000;
    private static final int SLEEP_INTERVAL = 10;

    public static void pause(Condition condition) {
        Pause.pause(condition, 30000L);
    }

    public static void pause(Condition condition, Timeout timeout) {
        Pause.pause(condition, timeout.duration());
    }

    public static void pause(Condition condition, long timeout) {
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!condition.test()) {
            if (watch.isTimeOut()) {
                throw new WaitTimedOutError(Strings.concat((Object[])new Object[]{"Timed out waiting for ", condition}));
            }
            Pause.pause(10L);
        }
    }

    public static void pause(long timeout, TimeUnit unit) {
        if (unit == null) {
            throw new NullPointerException("Time unit cannot be null");
        }
        Pause.pause(unit.toMillis(timeout));
    }

    public static void pause(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void pause() {
        Pause.pause(10L);
    }

    private Pause() {
    }
}

