/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import org.fest.swing.core.FocusOwnerFinder;

final class FocusMonitor
extends FocusAdapter {
    private volatile boolean focused = false;

    static FocusMonitor addFocusMonitorTo(Component c) {
        return new FocusMonitor(c);
    }

    private FocusMonitor(Component c) {
        c.addFocusListener(this);
        this.focused = FocusOwnerFinder.focusOwner() == c;
    }

    public void focusGained(FocusEvent e) {
        this.focused = true;
    }

    public void focusLost(FocusEvent e) {
        this.focused = false;
    }

    boolean hasFocus() {
        return this.focused;
    }
}

