/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.PrintStream;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.SingleComponentHierarchy;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicComponentPrinter
implements ComponentPrinter {
    private static final String INDENTATION = "  ";
    private final ComponentHierarchy hierarchy;

    public static ComponentPrinter printerWithNewAwtHierarchy() {
        return new BasicComponentPrinter(NewHierarchy.ignoreExistingComponents());
    }

    public static ComponentPrinter printerWithCurrentAwtHierarchy() {
        return new BasicComponentPrinter(new ExistingHierarchy());
    }

    BasicComponentPrinter(ComponentHierarchy hierarchy) {
        this.hierarchy = hierarchy;
    }

    ComponentHierarchy hierarchy() {
        return this.hierarchy;
    }

    @Override
    public void printComponents(PrintStream out) {
        this.printComponents(out, (Container)null);
    }

    @Override
    public void printComponents(PrintStream out, Container root) {
        this.printComponents(out, null, root);
    }

    @Override
    public void printComponents(PrintStream out, Class<? extends Component> type) {
        this.printComponents(out, type, null);
    }

    @Override
    public void printComponents(PrintStream out, Class<? extends Component> type, Container root) {
        BasicComponentPrinter.print(this.hierarchy(root), type, out);
    }

    private ComponentHierarchy hierarchy(Container root) {
        return root != null ? new SingleComponentHierarchy(root, this.hierarchy) : this.hierarchy;
    }

    private static void print(ComponentHierarchy hierarchy, Class<? extends Component> type, PrintStream out) {
        for (Container container : hierarchy.roots()) {
            BasicComponentPrinter.print(container, hierarchy, type, 0, out);
        }
    }

    private static void print(Component c, ComponentHierarchy h, Class<? extends Component> type, int level, PrintStream out) {
        if (type == null || type.isAssignableFrom(c.getClass())) {
            BasicComponentPrinter.print(c, level, out);
        }
        for (Component child : h.childrenOf(c)) {
            BasicComponentPrinter.print(child, h, type, level + 1, out);
        }
    }

    private static void print(Component c, int level, PrintStream out) {
        for (int i = 0; i < level; ++i) {
            out.print(INDENTATION);
        }
        out.println(Formatting.format(c));
    }
}

