/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.fest.swing.core.BasicComponentPrinter;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.ComponentPrinter;
import org.fest.swing.core.FinderDelegate;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.NameAndTypeMatcher;
import org.fest.swing.core.NameMatcher;
import org.fest.swing.core.SingleComponentHierarchy;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.format.Formatting;
import org.fest.swing.hierarchy.ComponentHierarchy;
import org.fest.swing.hierarchy.ExistingHierarchy;
import org.fest.swing.hierarchy.NewHierarchy;
import org.fest.swing.util.System;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BasicComponentFinder
implements ComponentFinder {
    private final ComponentHierarchy hierarchy;
    private final ComponentPrinter printer;
    private final FinderDelegate finderDelegate = new FinderDelegate();
    private boolean includeHierarchyInComponentLookupException;

    public static ComponentFinder finderWithNewAwtHierarchy() {
        return new BasicComponentFinder(NewHierarchy.ignoreExistingComponents());
    }

    public static ComponentFinder finderWithCurrentAwtHierarchy() {
        return new BasicComponentFinder(new ExistingHierarchy());
    }

    BasicComponentFinder(ComponentHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.printer = new BasicComponentPrinter(hierarchy);
        this.includeHierarchyIfComponentNotFound(true);
    }

    @Override
    public ComponentPrinter printer() {
        return this.printer;
    }

    @Override
    public <T extends Component> T findByType(Class<T> type) {
        return this.findByType(type, false);
    }

    @Override
    public <T extends Component> T findByType(Class<T> type, boolean showing) {
        return (T)((Component)type.cast(this.find(new TypeMatcher(type, showing))));
    }

    @Override
    public <T extends Component> T findByType(Container root, Class<T> type) {
        return this.findByType(root, type, false);
    }

    @Override
    public <T extends Component> T findByType(Container root, Class<T> type, boolean showing) {
        return (T)((Component)type.cast(this.find(root, (ComponentMatcher)new TypeMatcher(type, showing))));
    }

    @Override
    public <T extends Component> T findByName(String name, Class<T> type) {
        return this.findByName(name, type, false);
    }

    @Override
    public <T extends Component> T findByName(String name, Class<T> type, boolean showing) {
        Component found = this.find(new NameAndTypeMatcher(name, type, showing));
        return (T)((Component)type.cast(found));
    }

    @Override
    public Component findByName(String name) {
        return this.findByName(name, false);
    }

    @Override
    public Component findByName(String name, boolean showing) {
        return this.find(new NameMatcher(name, showing));
    }

    @Override
    public <T extends Component> T find(GenericTypeMatcher<T> m) {
        return (T)this.find((ComponentMatcher)m);
    }

    @Override
    public Component find(ComponentMatcher m) {
        return this.find(this.hierarchy, m);
    }

    @Override
    public <T extends Component> T findByName(Container root, String name, Class<T> type) {
        return this.findByName(root, name, type, false);
    }

    @Override
    public <T extends Component> T findByName(Container root, String name, Class<T> type, boolean showing) {
        Component found = this.find(root, (ComponentMatcher)new NameAndTypeMatcher(name, type, showing));
        return (T)((Component)type.cast(found));
    }

    @Override
    public Component findByName(Container root, String name) {
        return this.findByName(root, name, false);
    }

    @Override
    public Component findByName(Container root, String name, boolean showing) {
        return this.find(root, (ComponentMatcher)new NameMatcher(name, showing));
    }

    @Override
    public <T extends Component> T find(Container root, GenericTypeMatcher<T> m) {
        return (T)this.find(root, (ComponentMatcher)m);
    }

    @Override
    public Component find(Container root, ComponentMatcher m) {
        return this.find(this.hierarchy(root), m);
    }

    private Component find(ComponentHierarchy h, ComponentMatcher m) {
        Collection<Component> found = this.finderDelegate.find(h, m);
        if (found.isEmpty()) {
            throw this.componentNotFound(h, m);
        }
        if (found.size() > 1) {
            throw BasicComponentFinder.multipleComponentsFound(found, m);
        }
        return found.iterator().next();
    }

    private ComponentLookupException componentNotFound(ComponentHierarchy h, ComponentMatcher m) {
        String message = Strings.concat((Object[])new Object[]{"Unable to find component using matcher ", m, "."});
        if (this.includeHierarchyIfComponentNotFound()) {
            message = Strings.concat((Object[])new Object[]{message, System.LINE_SEPARATOR, System.LINE_SEPARATOR, "Component hierarchy:", System.LINE_SEPARATOR, this.formattedHierarchy(BasicComponentFinder.root(h))});
        }
        throw new ComponentLookupException(message);
    }

    private static Container root(ComponentHierarchy h) {
        if (h instanceof SingleComponentHierarchy) {
            return ((SingleComponentHierarchy)h).root();
        }
        return null;
    }

    private String formattedHierarchy(Container root) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(out, true);
        this.printer.printComponents(printStream, root);
        printStream.flush();
        return new String(out.toByteArray());
    }

    private static ComponentLookupException multipleComponentsFound(Collection<Component> found, ComponentMatcher m) {
        StringBuilder message = new StringBuilder();
        message.append("Found more than one component using matcher ").append(m).append(".").append(System.LINE_SEPARATOR).append(System.LINE_SEPARATOR).append("Found:");
        for (Component c : found) {
            message.append(System.LINE_SEPARATOR).append(Formatting.format(c));
        }
        if (!found.isEmpty()) {
            message.append(System.LINE_SEPARATOR);
        }
        throw new ComponentLookupException(message.toString(), found);
    }

    @Override
    public boolean includeHierarchyIfComponentNotFound() {
        return this.includeHierarchyInComponentLookupException;
    }

    @Override
    public void includeHierarchyIfComponentNotFound(boolean newValue) {
        this.includeHierarchyInComponentLookupException = newValue;
    }

    @Override
    public Collection<Component> findAll(ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy, m);
    }

    @Override
    public Collection<Component> findAll(Container root, ComponentMatcher m) {
        return this.finderDelegate.find(this.hierarchy(root), m);
    }

    private ComponentHierarchy hierarchy(Container root) {
        if (root == null) {
            return this.hierarchy;
        }
        return new SingleComponentHierarchy(root, this.hierarchy);
    }
}

