/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import org.fest.swing.core.EventMode;
import org.fest.swing.core.Pause;
import org.fest.swing.core.Settings;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.input.InputState;
import org.fest.swing.monitor.WindowMonitor;
import org.fest.swing.util.AWT;

class AWTEventPoster {
    private final Toolkit toolkit;
    private final InputState inputState;
    private final WindowMonitor windowMonitor;
    private final Settings settings;
    private AWTEvent lastEventPosted;
    private MouseEvent lastMousePress;
    private boolean countingClicks;

    AWTEventPoster(Toolkit toolkit, InputState inputState, WindowMonitor windowMonitor, Settings settings) {
        this.toolkit = toolkit;
        this.inputState = inputState;
        this.windowMonitor = windowMonitor;
        this.settings = settings;
    }

    void postEvent(Component c, AWTEvent event) {
        if (this.isAWTMode() && AWT.isAWTPopupMenuBlocking()) {
            throw ActionFailedException.actionFailure("Event queue is blocked by an active AWT PopupMenu");
        }
        this.inputState.update(event);
        this.eventQueueFor(c).postEvent(event);
        Pause.pause(this.settings.delayBetweenEvents());
        this.verifyPostedEvent(c, event);
    }

    private boolean isAWTMode() {
        return EventMode.AWT.equals((Object)this.settings.eventMode());
    }

    private EventQueue eventQueueFor(Component c) {
        return c != null ? this.windowMonitor.eventQueueFor(c) : this.toolkit.getSystemEventQueue();
    }

    private void verifyPostedEvent(Component c, AWTEvent event) {
        AWTEvent previous = this.lastEventPosted;
        this.lastEventPosted = event;
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent mouseEvent = (MouseEvent)event;
        this.updateMousePressWith(mouseEvent);
        if (this.isAWTMode() && event.getID() == 502 && previous.getID() == 501) {
            long when = System.currentTimeMillis();
            int modifiers = mouseEvent.getModifiers();
            int x = mouseEvent.getX();
            int y = mouseEvent.getY();
            int clickCount = mouseEvent.getClickCount();
            this.postEvent(c, new MouseEvent(c, 500, when, modifiers, x, y, clickCount, false));
        }
    }

    private void updateMousePressWith(MouseEvent event) {
        int eventId = event.getID();
        if (eventId == 501) {
            this.lastMousePress = event;
            this.countingClicks = true;
            return;
        }
        if (eventId != 502 && eventId != 500) {
            this.countingClicks = false;
        }
    }

    AWTEvent lastEventPosted() {
        return this.lastEventPosted;
    }

    MouseEvent lastMousePress() {
        return this.lastMousePress;
    }

    boolean countingClicks() {
        return this.countingClicks;
    }

    void countingClicks(boolean newCountingClicks) {
        this.countingClicks = newCountingClicks;
    }

    InputState inputState() {
        return this.inputState;
    }

    Settings settings() {
        return this.settings;
    }
}

