/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.fest.swing.monitor.Windows;

class WindowVisibilityMonitor
extends WindowAdapter
implements ComponentListener {
    private final Windows windows;

    WindowVisibilityMonitor(Windows windows) {
        this.windows = windows;
    }

    public void componentShown(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Window)) {
            return;
        }
        this.windows.markAsShowing((Window)source);
    }

    public void componentHidden(ComponentEvent e) {
        Object source = e.getSource();
        if (!(source instanceof Window)) {
            return;
        }
        this.windows.markAsHidden((Window)source);
    }

    public void windowClosed(WindowEvent e) {
        Window w = e.getWindow();
        w.removeComponentListener(this);
        w.removeWindowListener(this);
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

