/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.launcher;

import org.fest.reflect.core.Reflection;
import org.fest.swing.exception.UnexpectedException;
import org.fest.swing.util.Arrays;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationLauncher {
    private final Class<?> applicationType;
    private String[] args = new String[0];

    public static ApplicationLauncher application(String applicationTypeName) {
        try {
            Class<?> applicationType = ApplicationLauncher.class.getClassLoader().loadClass(applicationTypeName);
            return ApplicationLauncher.application(applicationType);
        }
        catch (ClassNotFoundException e) {
            throw new UnexpectedException(Strings.concat((Object[])new Object[]{"Unable to load class ", Strings.quote((String)applicationTypeName)}), e);
        }
    }

    public static ApplicationLauncher application(Class<?> applicationType) {
        return new ApplicationLauncher(applicationType);
    }

    private ApplicationLauncher(Class<?> applicationType) {
        this.applicationType = applicationType;
    }

    public ApplicationLauncher withArgs(String ... newArgs) {
        if (newArgs == null) {
            throw new NullPointerException("The array of arguments should not be null");
        }
        this.args = Arrays.copyOf(newArgs);
        return this;
    }

    public void start() {
        Reflection.staticMethod((String)"main").withParameterTypes(new Class[]{String[].class}).in(this.applicationType).invoke(new Object[]{this.args});
    }
}

