/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.hierarchy;

import java.awt.AWTEvent;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import javax.swing.SwingUtilities;
import org.fest.swing.hierarchy.WindowFilter;
import org.fest.swing.util.AWTEvents;

public final class TransientWindowListener
implements AWTEventListener {
    private final WindowFilter filter;

    TransientWindowListener(WindowFilter filter) {
        this.filter = filter;
    }

    public void eventDispatched(AWTEvent e) {
        if (AWTEvents.windowOpened(e) || AWTEvents.windowShown(e)) {
            this.filter(this.sourceOf(e));
            return;
        }
        if (AWTEvents.windowClosed(e)) {
            Window w = this.sourceOf(e);
            if (this.filter.isIgnored(w)) {
                return;
            }
            this.filter.implicitlyIgnore(w);
            SwingUtilities.invokeLater(new DisposeAction(w, this.filter));
        }
    }

    private Window sourceOf(AWTEvent e) {
        return (Window)e.getSource();
    }

    private void filter(Window w) {
        if (this.filter.isImplicitlyIgnored(w)) {
            this.filter.recognize(w);
            return;
        }
        this.filterIfParentIsFiltered(w);
    }

    private void filterIfParentIsFiltered(Window w) {
        if (!this.filter.isIgnored(w.getParent())) {
            return;
        }
        this.filter.ignore(w);
    }

    private static class DisposeAction
    implements Runnable {
        private final Window w;
        private final WindowFilter filter;

        DisposeAction(Window w, WindowFilter filter) {
            this.w = w;
            this.filter = filter;
        }

        public void run() {
            if (this.filter.isImplicitlyIgnored(this.w)) {
                this.filter.ignore(this.w);
            }
        }
    }
}

