/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.JPopupMenuDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;
import org.fest.swing.fixture.JMenuItemFinder;
import org.fest.swing.fixture.JMenuItemFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPopupMenuFixture
extends ComponentFixture<JPopupMenu>
implements CommonComponentFixture {
    private JPopupMenuDriver driver;
    private final JMenuItemFinder menuItemFinder;

    public JPopupMenuFixture(Robot robot, JPopupMenu target) {
        super(robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, target);
        this.updateDriver(new JPopupMenuDriver(robot));
    }

    final void updateDriver(JPopupMenuDriver newDriver) {
        this.driver = newDriver;
    }

    public JMenuItemFixture menuItem(String name) {
        return new JMenuItemFixture(this.robot, this.driver.menuItem((JPopupMenu)this.target, name));
    }

    public JMenuItemFixture menuItem(GenericTypeMatcher<? extends JMenuItem> matcher) {
        return new JMenuItemFixture(this.robot, this.driver.menuItem((JPopupMenu)this.target, matcher));
    }

    public JMenuItemFixture menuItemWithPath(String ... path) {
        return new JMenuItemFixture(this.robot, this.menuItemFinder.menuItemWithPath(path));
    }

    public String[] menuLabels() {
        return this.driver.menuLabelsOf((JPopupMenu)this.target);
    }

    @Override
    public JPopupMenuFixture click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public JPopupMenuFixture click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public JPopupMenuFixture rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public JPopupMenuFixture pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public JPopupMenuFixture pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public JPopupMenuFixture releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public JPopupMenuFixture requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public JPopupMenuFixture requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public JPopupMenuFixture requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }
}

