/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import java.awt.Component;
import org.fest.swing.core.KeyPressInfo;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.core.Robot;
import org.fest.swing.core.Timeout;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.fixture.CommonComponentFixture;
import org.fest.swing.fixture.ComponentFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericComponentFixture<T extends Component>
extends ComponentFixture<T>
implements CommonComponentFixture {
    private ComponentDriver driver;

    public GenericComponentFixture(Robot robot, T target) {
        this(robot, new ComponentDriver(robot), target);
    }

    public GenericComponentFixture(Robot robot, ComponentDriver driver, T target) {
        super(robot, target);
        this.updateDriver(driver);
    }

    void updateDriver(ComponentDriver newDriver) {
        if (newDriver == null) {
            throw new NullPointerException("The driver should not be null");
        }
        this.driver = newDriver;
    }

    protected ComponentDriver driver() {
        return this.driver;
    }

    @Override
    public GenericComponentFixture<T> click() {
        this.driver.click(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> click(MouseButton button) {
        this.driver.click(this.target, button);
        return this;
    }

    @Override
    public GenericComponentFixture<T> click(MouseClickInfo mouseClickInfo) {
        this.driver.click(this.target, mouseClickInfo);
        return this;
    }

    @Override
    public GenericComponentFixture<T> doubleClick() {
        this.driver.doubleClick(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> rightClick() {
        this.driver.rightClick(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> focus() {
        this.driver.focus(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> pressAndReleaseKey(KeyPressInfo keyPressInfo) {
        this.driver.pressAndReleaseKey(this.target, keyPressInfo);
        return this;
    }

    @Override
    public GenericComponentFixture<T> pressAndReleaseKeys(int ... keyCodes) {
        this.driver.pressAndReleaseKeys(this.target, keyCodes);
        return this;
    }

    @Override
    public GenericComponentFixture<T> pressKey(int keyCode) {
        this.driver.pressKey(this.target, keyCode);
        return this;
    }

    @Override
    public GenericComponentFixture<T> releaseKey(int keyCode) {
        this.driver.releaseKey(this.target, keyCode);
        return this;
    }

    @Override
    public GenericComponentFixture<T> requireEnabled() {
        this.driver.requireEnabled(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> requireEnabled(Timeout timeout) {
        this.driver.requireEnabled(this.target, timeout);
        return this;
    }

    @Override
    public GenericComponentFixture<T> requireDisabled() {
        this.driver.requireDisabled(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> requireVisible() {
        this.driver.requireVisible(this.target);
        return this;
    }

    @Override
    public GenericComponentFixture<T> requireNotVisible() {
        this.driver.requireNotVisible(this.target);
        return this;
    }
}

