/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

public class JTextComponentDriver
extends JComponentDriver {
    private static final String EDITABLE_PROPERTY = "editable";
    private static final String TEXT_PROPERTY = "text";

    public JTextComponentDriver(Robot robot) {
        super(robot);
    }

    public void deleteText(JTextComponent textBox) {
        this.replaceText(textBox, null);
    }

    public void replaceText(JTextComponent textBox, String text) {
        if (!textBox.isEnabled()) {
            return;
        }
        this.selectAll(textBox);
        if (Strings.isEmpty((String)text) && !Strings.isEmpty((String)textBox.getText())) {
            this.invokeAction(textBox, "delete-previous");
            return;
        }
        this.enterText(textBox, text);
    }

    public void selectAll(JTextComponent textBox) {
        if (!textBox.isEnabled()) {
            return;
        }
        this.scrollToVisible(textBox, 0);
        this.invokeAction(textBox, "select-all");
    }

    public void enterText(JTextComponent textBox, String text) {
        if (!textBox.isEnabled()) {
            return;
        }
        this.focus(textBox);
        this.robot.enterText(text);
    }

    public void selectText(JTextComponent textBox, String text) {
        if (!textBox.isEnabled()) {
            return;
        }
        String actualText = textBox.getText();
        if (Strings.isEmpty((String)actualText)) {
            return;
        }
        int indexFound = actualText.indexOf(text);
        if (indexFound == -1) {
            return;
        }
        this.selectText(textBox, indexFound, indexFound + text.length());
    }

    public void selectText(JTextComponent textBox, int start, int end) {
        if (!textBox.isEnabled() || Strings.isEmpty((String)textBox.getText())) {
            return;
        }
        this.robot.moveMouse(textBox, this.scrollToVisible(textBox, start));
        this.robot.moveMouse(textBox, this.scrollToVisible(textBox, end));
        this.robot.invokeAndWait(new TextSelectionTask(textBox, start, end));
        this.verifySelectionMade(textBox, start, end);
    }

    private Point scrollToVisible(JTextComponent textBox, int index) {
        Rectangle indexLocation = this.locationOf(textBox, index);
        if (this.isRectangleVisible(textBox, indexLocation)) {
            return this.centerOf(indexLocation);
        }
        this.scrollToVisible(textBox, indexLocation);
        indexLocation = this.locationOf(textBox, index);
        if (this.isRectangleVisible(textBox, indexLocation)) {
            return this.centerOf(indexLocation);
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to make visible the location of the index '", String.valueOf(index), "' by scrolling the point (", this.formatOriginOf(indexLocation), ") on ", Formatting.format(textBox)}));
    }

    private Rectangle locationOf(JTextComponent textBox, int index) {
        Rectangle r = null;
        try {
            r = textBox.modelToView(index);
        }
        catch (BadLocationException e) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to get location for index '", String.valueOf(index), "' in ", Formatting.format(textBox)}));
        }
        if (r != null) {
            return r;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Text component", Formatting.format(textBox), " has zero size"}));
    }

    private boolean isRectangleVisible(JTextComponent textBox, Rectangle r) {
        return textBox.getVisibleRect().contains(r.x, r.y);
    }

    private String formatOriginOf(Rectangle r) {
        return Strings.concat((Object[])new Object[]{String.valueOf(r.x), ",", String.valueOf(r.y)});
    }

    private void scrollToVisible(JTextComponent textBox, Rectangle r) {
        super.scrollToVisible(textBox, r);
        if (this.isVisible((JComponent)textBox, r)) {
            return;
        }
        this.scrollToVisibleIfIsTextField(textBox, r);
    }

    private void scrollToVisibleIfIsTextField(JTextComponent textBox, Rectangle r) {
        Container parent;
        if (!(textBox instanceof JTextField)) {
            return;
        }
        Point origin = this.origin(textBox);
        for (parent = textBox.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            this.addRectangleCoordinatesToPoint(parent.getBounds(), origin);
        }
        if (parent == null || parent instanceof CellRendererPane) {
            return;
        }
        super.scrollToVisible((JComponent)parent, this.rectangleWithPointAddedToCoordinates(origin, r));
    }

    private Point origin(JTextComponent textBox) {
        return new Point(textBox.getX(), textBox.getY());
    }

    private void addRectangleCoordinatesToPoint(Rectangle r, Point p) {
        p.x += r.x;
        p.y += r.y;
    }

    private Rectangle rectangleWithPointAddedToCoordinates(Point p, Rectangle r) {
        Rectangle destination = new Rectangle(r);
        destination.x += p.x;
        destination.y += p.y;
        return destination;
    }

    private Point centerOf(Rectangle r) {
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    private void verifySelectionMade(JTextComponent textBox, int start, int end) {
        int actualStart = textBox.getSelectionStart();
        int actualEnd = textBox.getSelectionEnd();
        if (actualStart == Math.min(start, end) && actualEnd == Math.max(start, end)) {
            return;
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to select text using indices '", String.valueOf(start), "' and '", String.valueOf(end), ", current selection starts at '", String.valueOf(actualStart), "' and ends at '", String.valueOf(actualEnd), "'"}));
    }

    public void requireText(JTextComponent textBox, String expected) {
        Assertions.assertThat((String)textBox.getText()).as(JTextComponentDriver.textProperty(textBox)).isEqualTo(expected);
    }

    public void requireEmpty(JTextComponent textBox) {
        Assertions.assertThat((String)textBox.getText()).as(JTextComponentDriver.textProperty(textBox)).isEmpty();
    }

    private static String textProperty(JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, TEXT_PROPERTY);
    }

    public void requireEditable(JTextComponent textBox) {
        Assertions.assertThat((boolean)textBox.isEditable()).as(JTextComponentDriver.editableProperty(textBox)).isTrue();
    }

    public void requireNotEditable(JTextComponent textBox) {
        Assertions.assertThat((boolean)textBox.isEditable()).as(JTextComponentDriver.editableProperty(textBox)).isFalse();
    }

    private static String editableProperty(JTextComponent textBox) {
        return JTextComponentDriver.propertyName(textBox, EDITABLE_PROPERTY);
    }

    private static class TextSelectionTask
    implements Runnable {
        private final JTextComponent textBox;
        private final int start;
        private final int end;

        TextSelectionTask(JTextComponent textBox, int start, int end) {
            this.textBox = textBox;
            this.start = start;
            this.end = end;
        }

        public void run() {
            this.textBox.setCaretPosition(this.start);
            this.textBox.moveCaretPosition(this.end);
        }
    }
}

