/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.swing.JTable;
import org.fest.util.Strings;

public abstract class JTableCell {
    public final int row;
    public final int column;

    static JTableCell cell(int row, int column) {
        return new JTableCell(row, column){};
    }

    public JTableCell(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public void validateBoundsIn(JTable table) {
        if (table.getRowCount() == 0) {
            throw new IndexOutOfBoundsException("Table does not contain any rows");
        }
        JTableCell.validateRow(table, this.row);
        JTableCell.validateColumn(table, this.column);
    }

    protected static void validateRow(JTable table, int row) {
        JTableCell.validateIndex(row, table.getRowCount(), "row");
    }

    protected static void validateColumn(JTable table, int column) {
        JTableCell.validateIndex(column, table.getColumnCount(), "column");
    }

    private static void validateIndex(int index, int itemCount, String indexName) {
        if (index >= 0 && index < itemCount) {
            return;
        }
        throw new IndexOutOfBoundsException(Strings.concat((Object[])new Object[]{indexName, " ", Strings.quote((String)String.valueOf(index)), " should be between ", Strings.quote((String)"0"), " and ", Strings.quote((String)String.valueOf(itemCount))}));
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{"[row=", String.valueOf(this.row), ", column=", String.valueOf(this.column), "]"});
    }
}

