/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.fest.assertions.Assertions;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.JButtonMatcher;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JOptionPaneMessageTypes;

public class JOptionPaneDriver
extends JComponentDriver {
    private static final String MESSAGE_PROPERTY = "message";
    private static final String MESSAGE_TYPE_PROPERTY = "messageType";
    private static final String OPTIONS_PROPERTY = "options";
    private static final String TITLE_PROPERTY = "title";

    public JOptionPaneDriver(Robot robot) {
        super(robot);
    }

    public void requireTitle(JOptionPane optionPane, String title) {
        String actualTitle = ((Dialog)optionPane.getRootPane().getParent()).getTitle();
        Assertions.assertThat((String)actualTitle).as(JOptionPaneDriver.propertyName(optionPane, TITLE_PROPERTY)).isEqualTo(title);
    }

    public void requireMessage(JOptionPane optionPane, Object message) {
        Assertions.assertThat((Object)optionPane.getMessage()).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_PROPERTY)).isEqualTo(message);
    }

    public void requireOptions(JOptionPane optionPane, Object[] options) {
        Assertions.assertThat((Object[])optionPane.getOptions()).as(JOptionPaneDriver.propertyName(optionPane, OPTIONS_PROPERTY)).isEqualTo(options);
    }

    public JButton okButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.okButtonText");
    }

    public JButton cancelButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.cancelButtonText");
    }

    public JButton yesButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.yesButtonText");
    }

    public JButton noButton(JOptionPane optionPane) {
        return this.buttonWithTextFromUIManager(optionPane, "OptionPane.noButtonText");
    }

    private JButton buttonWithTextFromUIManager(JOptionPane optionPane, String key) {
        return this.buttonWithText(optionPane, UIManager.getString(key));
    }

    public JButton buttonWithText(JOptionPane optionPane, String text) {
        return this.robot.finder().find((Container)optionPane, new JButtonMatcher(text));
    }

    public JButton button(JOptionPane optionPane) {
        return this.robot.finder().findByType(optionPane, JButton.class);
    }

    public JTextComponent textBox(JOptionPane optionPane) {
        return this.robot.finder().findByType(optionPane, JTextComponent.class);
    }

    public void requireErrorMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 0);
    }

    public void requireInformationMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 1);
    }

    public void requireWarningMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 2);
    }

    public void requireQuestionMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, 3);
    }

    public void requirePlainMessage(JOptionPane optionPane) {
        this.assertEqualMessageType(optionPane, -1);
    }

    private void assertEqualMessageType(JOptionPane optionPane, int expected) {
        String actualType = this.actualMessageTypeAsText(optionPane);
        Assertions.assertThat((String)actualType).as(JOptionPaneDriver.propertyName(optionPane, MESSAGE_TYPE_PROPERTY)).isEqualTo(JOptionPaneMessageTypes.messageTypeAsText(expected));
    }

    private String actualMessageTypeAsText(JOptionPane optionPane) {
        return JOptionPaneMessageTypes.messageTypeAsText(optionPane.getMessageType());
    }
}

