/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListModel;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.fest.swing.cell.JListCellReader;
import org.fest.swing.core.MouseButton;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.BasicJListCellReader;
import org.fest.swing.driver.CommonValidations;
import org.fest.swing.driver.JComponentDriver;
import org.fest.swing.driver.JListLocation;
import org.fest.swing.driver.MultipleSelectionTemplate;
import org.fest.swing.exception.LocationUnavailableException;
import org.fest.swing.util.AWT;
import org.fest.swing.util.Range;
import org.fest.util.Arrays;
import org.fest.util.Objects;
import org.fest.util.Strings;

public class JListDriver
extends JComponentDriver {
    private static final String SELECTED_INDICES_PROPERTY = "selectedIndices";
    private static final String SELECTED_INDICES_LENGTH_PROPERTY = Strings.concat((Object[])new Object[]{"selectedIndices", "#length"});
    private static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private final JListLocation location = new JListLocation();
    private JListCellReader cellReader;

    public JListDriver(Robot robot) {
        super(robot);
        this.cellReader(new BasicJListCellReader());
    }

    public String[] contentsOf(JList list) {
        String[] values = new String[this.sizeOf(list)];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.value(list, i);
        }
        return values;
    }

    public String[] selectionOf(JList list) {
        int[] selectedIndices = list.getSelectedIndices();
        int selectionCount = selectedIndices.length;
        String[] values = new String[selectionCount];
        for (int i = 0; i < selectionCount; ++i) {
            values[i] = this.value(list, selectedIndices[i]);
        }
        return values;
    }

    private int sizeOf(JList list) {
        return this.model(list).getSize();
    }

    private ListModel model(JList list) {
        return list.getModel();
    }

    public void selectItems(final JList list, final String[] values) {
        if (values == null) {
            throw new NullPointerException("Array of values should not be null");
        }
        if (Arrays.isEmpty((Object[])values)) {
            throw new IllegalArgumentException("Array of values should not beempty");
        }
        if (!list.isEnabled()) {
            return;
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return values.length;
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, values[index]);
            }
        }.multiSelect();
    }

    public void selectItem(JList list, String value) {
        this.selectItem(list, this.indexOf(list, value));
    }

    public void clickItem(JList list, String value, MouseButton button, int times) {
        this.clickItem(list, this.indexOf(list, value), button, times);
    }

    public void selectItems(final JList list, final int[] indices) {
        if (indices == null) {
            throw new NullPointerException("The array of indices should not be null");
        }
        if (this.isEmptyArray(indices)) {
            throw new IllegalArgumentException("The array of indices should not be empty");
        }
        if (!list.isEnabled()) {
            return;
        }
        new MultipleSelectionTemplate(this.robot){

            int elementCount() {
                return indices.length;
            }

            void selectElement(int index) {
                JListDriver.this.selectItem(list, indices[index]);
            }
        }.multiSelect();
    }

    private boolean isEmptyArray(int[] array) {
        return array == null || array.length == 0;
    }

    public void selectItems(JList list, Range.From from, Range.To to) {
        this.selectItems(list, from.value, to.value);
    }

    public void selectItems(JList list, int start, int end) {
        this.selectItem(list, start);
        this.robot.pressKey(16);
        this.selectItem(list, end);
        this.robot.releaseKey(16);
    }

    public void selectItem(JList list, int index) {
        if (list.isSelectedIndex(index)) {
            return;
        }
        this.clickItem(list, index, MouseButton.LEFT_BUTTON, 1);
    }

    public void clickItem(JList list, int index, MouseButton button, int times) {
        if (!list.isEnabled()) {
            return;
        }
        this.scrollToVisible(list, index);
        this.robot.click(list, this.location.pointAt(list, index), button, times);
    }

    public void requireSelection(JList list, String value) {
        int selectedIndex = list.getSelectedIndex();
        if (selectedIndex == -1) {
            this.failNoSelection(list);
        }
        Assertions.assertThat((String)this.value(list, selectedIndex)).as(this.selectedIndexProperty(list)).isEqualTo(value);
    }

    public void requireSelectedItems(JList list, String ... items) {
        if (items == null) {
            throw new NullPointerException("The array of items should not be null");
        }
        int[] selectedIndices = list.getSelectedIndices();
        int currentSelectionCount = selectedIndices.length;
        if (currentSelectionCount == 0) {
            this.failNoSelection(list);
        }
        Assertions.assertThat((int)currentSelectionCount).as(JListDriver.propertyName(list, SELECTED_INDICES_LENGTH_PROPERTY)).isEqualTo(items.length);
        for (int i = 0; i < currentSelectionCount; ++i) {
            String description = JListDriver.propertyName(list, Strings.concat((Object[])new Object[]{SELECTED_INDICES_PROPERTY, "[", String.valueOf(i), "]"}));
            Assertions.assertThat((String)this.value(list, selectedIndices[i])).as(description).isEqualTo(items[i]);
        }
    }

    public void requireNoSelection(JList list) {
        Assertions.assertThat((int)list.getSelectedIndex()).as(this.selectedIndexProperty(list)).isEqualTo(-1);
    }

    private void failNoSelection(JList list) {
        Fail.fail((String)Strings.concat((Object[])new Object[]{"[", this.selectedIndexProperty(list), "] No selection"}));
    }

    private String selectedIndexProperty(JList list) {
        return JListDriver.propertyName(list, SELECTED_INDEX_PROPERTY);
    }

    public void drag(JList list, String value) {
        this.drag(list, this.indexOf(list, value));
    }

    public void drop(JList list, String value) {
        this.drop(list, this.indexOf(list, value));
    }

    public void drag(JList list, int index) {
        this.scrollToVisible(list, index);
        super.drag(list, this.pointAt(list, index));
    }

    public void drop(JList list, int index) {
        this.scrollToVisible(list, index);
        super.drop(list, this.pointAt(list, index));
    }

    public void drop(JList list) {
        super.drop(list, AWT.centerOf(list));
    }

    private Rectangle itemBounds(JList list, int index) {
        return list.getCellBounds(index, index);
    }

    private Point pointAt(JList list, int index) {
        return this.location.pointAt(list, index);
    }

    public JPopupMenu showPopupMenu(JList list, String value) {
        return this.showPopupMenu(list, this.indexOf(list, value));
    }

    public JPopupMenu showPopupMenu(JList list, int index) {
        this.scrollToVisible(list, index);
        return this.robot.showPopupMenu(list, this.pointAt(list, index));
    }

    private void scrollToVisible(JList list, int index) {
        super.scrollToVisible(list, this.itemBounds(list, index));
    }

    public Point pointAt(JList list, String value) {
        return this.location.pointAt(list, this.indexOf(list, value));
    }

    public int indexOf(JList list, String value) {
        int size = this.sizeOf(list);
        for (int i = 0; i < size; ++i) {
            if (!Objects.areEqual((Object)value, (Object)this.value(list, i))) continue;
            return i;
        }
        throw this.indexNotFoundFor(value);
    }

    public String value(JList list, int index) {
        this.location.validate(list, index);
        return this.cellReader.valueAt(list, index);
    }

    private LocationUnavailableException indexNotFoundFor(String value) {
        throw new LocationUnavailableException(Strings.concat((Object[])new Object[]{"Unable to find an element matching the value ", Strings.quote((String)value)}));
    }

    public void cellReader(JListCellReader newCellReader) {
        CommonValidations.validateCellReader(newCellReader);
        this.cellReader = newCellReader;
    }
}

