/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.Actions;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.KeyStrokes;
import org.fest.swing.driver.ScrollRectToVisibleTask;
import org.fest.swing.exception.ActionFailedException;
import org.fest.util.Strings;

public class JComponentDriver
extends ContainerDriver {
    public JComponentDriver(Robot robot) {
        super(robot);
    }

    protected final void scrollToVisible(JComponent c, Rectangle r) {
        this.robot.invokeAndWait(new ScrollRectToVisibleTask(c, r));
    }

    protected final boolean isVisible(JComponent c, Rectangle r) {
        return this.visibleRectangleOf(c).contains(r);
    }

    protected final boolean isVisible(JComponent c, Point p) {
        return this.visibleRectangleOf(c).contains(p);
    }

    private Rectangle visibleRectangleOf(JComponent c) {
        return c.getVisibleRect();
    }

    public final void invokeAction(JComponent c, String name) {
        KeyStroke[] keyStrokes;
        this.focusAndWaitForFocusGain(c);
        Object key = Actions.findActionKey(name, c.getActionMap());
        for (KeyStroke keyStroke : keyStrokes = KeyStrokes.findKeyStrokesForAction(name, key, c.getInputMap())) {
            try {
                this.type(keyStroke);
                this.robot.waitForIdle();
                return;
            }
            catch (IllegalArgumentException e) {
            }
        }
        throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to type any key for the action with key ", Strings.quote((String)name)}));
    }

    private void type(KeyStroke keyStroke) {
        if (keyStroke.getKeyCode() == 0) {
            this.robot.type(keyStroke.getKeyChar());
            return;
        }
        this.robot.pressAndReleaseKey(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }
}

