/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.AWTException;
import java.util.HashMap;
import java.util.Map;
import org.fest.swing.core.AWTEventGenerator;
import org.fest.swing.core.AWTEventPoster;
import org.fest.swing.core.EventMode;
import org.fest.swing.core.InputEventGenerator;
import org.fest.swing.core.RobotEventGenerator;
import org.fest.swing.core.Settings;

class InputEventGenerators {
    private final Map<EventMode, InputEventGenerator> eventGeneratorMap = new HashMap<EventMode, InputEventGenerator>();
    private final Settings settings;
    private final AWTEventGenerator awtEventGenerator;

    InputEventGenerators(AWTEventPoster eventPoster) {
        this.settings = eventPoster.settings();
        try {
            RobotEventGenerator robotEventGenerator = this.robotEventGenerator();
            this.eventGeneratorMap.put(EventMode.ROBOT, robotEventGenerator);
        }
        catch (AWTException e) {
            this.settings.eventMode(EventMode.AWT);
        }
        this.awtEventGenerator = new AWTEventGenerator(eventPoster);
        this.eventGeneratorMap.put(EventMode.AWT, this.awtEventGenerator);
    }

    RobotEventGenerator robotEventGenerator() throws AWTException {
        return new RobotEventGenerator(this.settings);
    }

    InputEventGenerator current() {
        InputEventGenerator inputEventGenerator = this.eventGeneratorMap.get((Object)this.settings.eventMode());
        if (inputEventGenerator != null) {
            return inputEventGenerator;
        }
        return this.awtEventGenerator;
    }
}

