/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Formatting;
import org.fest.assertions.GroupAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringAssert
extends GroupAssert<String> {
    StringAssert(String actual) {
        super(actual);
    }

    public StringAssert as(String description) {
        this.description(description);
        return this;
    }

    public StringAssert describedAs(String description) {
        return this.as(description);
    }

    public StringAssert satisfies(Condition<String> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public StringAssert doesNotSatisfy(Condition<String> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    @Override
    public void isEmpty() {
        this.isNotNull();
        if (!Strings.isEmpty((String)((String)this.actual))) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting empty String but was:", Formatting.inBrackets(this.actual)}));
        }
    }

    @Override
    public final void isNullOrEmpty() {
        if (Strings.isEmpty((String)((String)this.actual))) {
            return;
        }
        this.fail(Strings.concat((Object[])new Object[]{"expecting a null or empty String, but was:", Formatting.inBrackets(this.actual)}));
    }

    public StringAssert isNotEmpty() {
        this.isNotNull();
        if (Strings.isEmpty((String)((String)this.actual))) {
            this.fail(Strings.concat((Object[])new Object[]{"expecting a non-empty String, but it was empty"}));
        }
        return this;
    }

    public StringAssert isEqualTo(String expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public StringAssert isNotEqualTo(String other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public StringAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public StringAssert isNotSameAs(String other) {
        this.assertNotSameAs(other);
        return this;
    }

    public StringAssert isSameAs(String expected) {
        this.assertSameAs(expected);
        return this;
    }

    public StringAssert hasSize(int expected) {
        int actualSize = this.actualGroupSize();
        if (actualSize != expected) {
            this.fail(Strings.concat((Object[])new Object[]{"expected size:", Formatting.inBrackets(expected), " but was:", Formatting.inBrackets(actualSize), " for String:", this.actual()}));
        }
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((String)this.actual).length();
    }

    public StringAssert contains(String expected) {
        this.isNotNull();
        if (((String)this.actual).indexOf(expected) == -1) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should contain the String:", Formatting.inBrackets(expected)}));
        }
        return this;
    }

    public StringAssert endsWith(String expected) {
        this.isNotNull();
        if (!((String)this.actual).endsWith(expected)) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should end with:", Formatting.inBrackets(expected)}));
        }
        return this;
    }

    public StringAssert startsWith(String expected) {
        this.isNotNull();
        if (!((String)this.actual).startsWith(expected)) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should start with:", Formatting.inBrackets(expected)}));
        }
        return this;
    }

    public StringAssert excludes(String s) {
        this.isNotNull();
        if (((String)this.actual).indexOf(s) != -1) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should not contain the String:", Formatting.inBrackets(s)}));
        }
        return this;
    }

    public StringAssert matches(String regex) {
        this.isNotNull();
        if (!((String)this.actual).matches(regex)) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should match the regular expression:", Formatting.inBrackets(regex)}));
        }
        return this;
    }

    public StringAssert doesNotMatch(String regex) {
        this.isNotNull();
        if (((String)this.actual).matches(regex)) {
            this.fail(Strings.concat((Object[])new Object[]{this.actual(), " should not match the regular expression:", Formatting.inBrackets(regex)}));
        }
        return this;
    }

    private String actual() {
        return Formatting.inBrackets(this.actual);
    }
}

