/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Fail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntArrayAssert
extends ArrayAssert<int[]> {
    IntArrayAssert(int ... actual) {
        super(actual);
    }

    public IntArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public IntArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public IntArrayAssert contains(int ... values) {
        this.isNotNull();
        this.assertContains(this.list(values));
        return this;
    }

    public IntArrayAssert containsOnly(int ... values) {
        this.isNotNull();
        this.assertContainsOnly(this.list(values));
        return this;
    }

    public IntArrayAssert excludes(int ... values) {
        this.isNotNull();
        this.assertExcludes(this.list(values));
        return this;
    }

    @Override
    List<Object> copyActual() {
        return this.list((int[])this.actual);
    }

    private List<Object> list(int[] values) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int value : values) {
            list.add(value);
        }
        return list;
    }

    public IntArrayAssert satisfies(Condition<int[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public IntArrayAssert doesNotSatisfy(Condition<int[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public IntArrayAssert isNotNull() {
        this.assertArrayNotNull();
        return this;
    }

    public IntArrayAssert isNotEmpty() {
        this.assertNotEmpty();
        return this;
    }

    public IntArrayAssert isEqualTo(int[] expected) {
        if (!Arrays.equals((int[])this.actual, expected)) {
            this.fail(Fail.errorMessageIfNotEqual(this.actual, expected));
        }
        return this;
    }

    public IntArrayAssert isNotEqualTo(int[] array) {
        if (Arrays.equals((int[])this.actual, array)) {
            this.fail(Fail.errorMessageIfEqual(this.actual, array));
        }
        return this;
    }

    public IntArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    @Override
    int actualGroupSize() {
        this.isNotNull();
        return ((int[])this.actual).length;
    }

    public IntArrayAssert isSameAs(int[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public IntArrayAssert isNotSameAs(int[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }
}

