/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.fest.reflect.core.Reflection;
import org.fest.swing.util.MouseEventTarget;
import org.fest.swing.util.Platform;
import org.fest.util.Strings;

public class AWT {
    private static final String APPLET_APPLET_VIEWER_CLASS = "sun.applet.AppletViewer";
    private static final String ROOT_FRAME_CLASSNAME = Strings.concat((Object[])new Object[]{SwingUtilities.class.getName(), "$"});
    private static final boolean POPUP_ON_BUTTON2 = false;

    public static Point centerOf(Component c) {
        return new Point(c.getWidth() / 2, c.getHeight() / 2);
    }

    public static Insets insetsFrom(Container c) {
        try {
            Insets insets = c.getInsets();
            if (insets != null) {
                return insets;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Insets(0, 0, 0, 0);
    }

    public static boolean isAppletViewer(Component c) {
        return c != null && APPLET_APPLET_VIEWER_CLASS.equals(c.getClass().getName());
    }

    public static boolean isSharedInvisibleFrame(Component c) {
        if (c == null) {
            return false;
        }
        return c instanceof Frame && (c == JOptionPane.getRootFrame() || c.getClass().getName().startsWith(ROOT_FRAME_CLASSNAME));
    }

    public static void runInEventThreadAndWait(Runnable r) throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
            return;
        }
        SwingUtilities.invokeAndWait(r);
    }

    public static String quoteNameOf(Component c) {
        if (c == null) {
            return null;
        }
        return Strings.quote((String)c.getName());
    }

    public static Component invokerOf(Component c) {
        if (c instanceof JPopupMenu) {
            return ((JPopupMenu)c).getInvoker();
        }
        Container parent = c.getParent();
        return parent != null ? AWT.invokerOf(parent) : null;
    }

    public static Point locationOnScreenOf(Component c) {
        if (!AWT.isAWTTreeLockHeld()) {
            new Point(c.getLocationOnScreen());
        }
        if (!c.isShowing()) {
            return null;
        }
        Point location = new Point(c.getLocation());
        if (c instanceof Window) {
            return location;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return null;
        }
        Point parentLocation = AWT.locationOnScreenOf(parent);
        location.translate(parentLocation.x, parentLocation.y);
        return location;
    }

    public static boolean isAWTPopupMenuBlocking() {
        return AWT.isAWTTreeLockHeld();
    }

    public static MouseEventTarget retargetMouseEvent(Component c, int eventId, Point where) {
        Component source = c;
        Point coordinates = where;
        while (!(c instanceof Window) && !AWT.eventTypeEnabled(source, eventId)) {
            coordinates = SwingUtilities.convertPoint(source, coordinates.x, coordinates.y, source.getParent());
            source = source.getParent();
        }
        return new MouseEventTarget(source, coordinates);
    }

    public static boolean popupOnPress() {
        return !Platform.isWindows();
    }

    public static int popupMask() {
        return 4;
    }

    public static boolean eventTypeEnabled(Component c, int eventId) {
        if (c instanceof Choice) {
            return true;
        }
        try {
            AWTEvent event = AWT.fakeAWTEventFrom(c, eventId);
            return (Boolean)Reflection.method((String)"eventEnabled").withReturnType(Boolean.TYPE).withParameterTypes(new Class[]{AWTEvent.class}).in((Object)c).invoke(new Object[]{event});
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    private static AWTEvent fakeAWTEventFrom(Component c, int eventId) {
        return new AWTEvent(c, eventId){
            private static final long serialVersionUID = 1L;
        };
    }

    public static boolean isAWTTreeLockHeld() {
        Frame[] frames = Frame.getFrames();
        if (frames.length == 0) {
            return false;
        }
        ThreadStateChecker checker = new ThreadStateChecker(frames[0].getTreeLock());
        try {
            checker.start();
            if (checker.isAlive()) {
                checker.join(100L);
            }
            return checker.isAlive();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private AWT() {
    }

    private static class ThreadStateChecker
    extends Thread {
        public boolean started;
        private final Object lock;

        public ThreadStateChecker(Object lock) {
            super("Thread state checker");
            this.setDaemon(true);
            this.lock = lock;
        }

        public synchronized void start() {
            super.start();
            try {
                this.wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this;
            synchronized (object) {
                this.started = true;
                this.notifyAll();
            }
            object = this.lock;
            synchronized (object) {
                this.setName(super.getName());
            }
        }
    }
}

